#!/bin/bash
#
# ACStart.sh - Starts the Agent Controller server process.
#

#
# If TPTP_AC_HOME is not set then set it to the parent directory of the directory containing this script
#
if [ -z "$TPTP_AC_HOME" ]; then
	TPTP_AC_HOME=`dirname "$0"`/..
	export TPTP_AC_HOME
fi
PATH="$TPTP_AC_HOME/bin":$PATH
export PATH

#
# Make sure TPTP_AC_HOME is valid
#
if [ -e "$TPTP_AC_HOME/bin/ACServer" ] ; then
	echo "Starting Agent Controller."
else
	echo "TPTP_AC_HOME not set properly. Could not locate bin/ACServer at that location."
	echo "TPTP_AC_HOME=" $TPTP_AC_HOME
	exit 67
fi

#
# Bug 301163, check for the serviceconfig.xml
# Parse the configuration file for the location of the jvm library
#
if [ -e "$TPTP_AC_HOME/config/serviceconfig.xml" ] ; then
    JVM_LIB=`grep '<Jvm' "$TPTP_AC_HOME/config/serviceconfig.xml" | sed 's/<Jvm location="\(.*\)"\/>/\1/'`
    export JVM_LIB

#
# Set the library path(s) based on the location of the jvm library (".." is the parent directory which
# also holds other dependent *.so)
#
	LIBPATH="$TPTP_AC_HOME/lib":`echo $JVM_LIB | sed 's/\(.*\)\/libjvm\.so/\1/'`:`echo $JVM_LIB | sed 's/\(.*\)\/libjvm\.so/\1/' | sed 's/\(.*\)\/.*/\1/'`:/usr/lib:$LIBPATH
else
	LIBPATH="$TPTP_AC_HOME/lib":/usr/lib:$LIBPATH
fi
export LIBPATH

#
# Check that xml4c is in LIBPATH
#
SAVEIFS=$IFS
IFS=:

for dir in $LIBPATH
do
        ls "$dir"/libxml4c* 1>/dev/null 2>&1
        if [ "$?" -eq "0"  ]; then
                export isXML4CFound=true
                break
        fi
done

IFS=$SAVEIFS

if [ ! $isXML4CFound ]; then 
		echo "ERROR: Cannot find the location of the z/OS XML Toolkit, xml4c, on the LIBPATH. Consult the Getting Started document for additional information."
        exit 68
fi

#
# Bug 175696, 201989
# Make sure TEMP dir is set
#
if [[ -n $TEMP ]]; then
	if [[ -d $TEMP ]]; then
		echo
	else
		export TEMP=/tmp
	fi
else
	export TEMP=/tmp
fi

#
# Start the ACServer
#
RUNNING=`ps -e | grep "ACServer" | wc -l`
if [ $RUNNING -ne 0 ];then
	ps -e | grep "ACServer" | awk '{
  	print "The server is already running on pid " $1
	}'      
	exit 66
else
    ACServer $* &
fi

#
# Wait for the process to come up in the system process list
#
sleep 2

#
# Check if ACServer is running by querying the system process list
#
ps -e | grep "ACServer" | wc -l | awk '{
	if( $1 -ne 0 ) {
		print "ACServer started successfully."
		exit 0
	}
	else {
		print "ACServer failed to start."
		exit 1
	}
}'
