#!/bin/bash
#
# ACStop.sh - Stops the Agent Controller server process if it is running.
#

# If TPTP_AC_HOME is not set then set it to the parent directory of the directory containing this script
#
if [ -z "$TPTP_AC_HOME" ]; then
	TPTP_AC_HOME=`dirname "$0"`/..
	export TPTP_AC_HOME
fi
PATH="$TPTP_AC_HOME/bin":$PATH
export PATH

# Bug 301163, check for the serviceconfig.xml
if [ -e "$TPTP_AC_HOME/config/serviceconfig.xml" ]; then
	JVM_LIB=`grep '<Jvm' "$TPTP_AC_HOME/config/serviceconfig.xml" | sed 's/<Jvm location="\(.*\)"\/>/\1/'`
	LIBPATH="$TPTP_AC_HOME/lib":`echo $JVM_LIB | sed 's/\(.*\)\/libjvm\.so/\1/'`:`echo $JVM_LIB | sed 's/\(.*\)\/libjvm\.so/\1/' | sed 's/\(.*\)\/.*/\1/'`:/usr/lib:$LIBPATH
else
	LIBPATH="$TPTP_AC_HOME/lib":/usr/lib:$LIBPATH
fi

# Set LIBPATH because we are going to run another occurrence of the server
# that will tell the existing one to shutdown.
#LIBPATH=$TPTP_AC_HOME/lib:$LIBPATH
export LIBPATH

#
# Check that xml4c is in LIBPATH
#
SAVEIFS=$IFS
IFS=:

for dir in $LIBPATH
do
        ls "$dir"/libxml4c* 1>/dev/null 2>&1
        if [ "$?" -eq "0"  ]; then
                export isXML4CFound=true
                break
        fi
done

IFS=$SAVEIFS

if [ ! $isXML4CFound ]; then 
		echo "ERROR: Cannot find the location of the z/OS XML Toolkit, xml4c, on the LIBPATH. Consult the Getting Started document for additional information."
        exit 68
fi

#
# Bug 175696, 201989
# Make sure TEMP dir is set
#
if [[ -n $TEMP ]]; then
	if [[ -d $TEMP ]]; then
		echo
	else
		export TEMP=/tmp
	fi
else
	export TEMP=/tmp
fi

RUNNING=`ps -e | grep "ACServer" | wc -l`
if [ $RUNNING -ne 0 ];then
	ACServer -shutdown
        echo "ACServer stopped."
        exit 0
else
        echo "ACServer is not currently running."
        exit 0
fi
