/*******************************************************************************
 * Copyright (c) 2005, 2007 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu K Naikawad, Intel - Initial implementation
 *    Andy Kaylor, Intel - Modified sample client to work with legacy agent
 *
 * $Id: CompClient.cpp,v 1.5 2007/05/22 16:21:05 samwai Exp $
 *
 *******************************************************************************/ 



#include <iostream>
#include <stdlib.h>
#include <stdio.h>

#include "tptp/client/INode.h"
#include "tptp/client/NodeFactory.h"
#include "tptp/client/Agent.h"
#include "tptp/client/Collector.h"
#include "DumpDataProcessor.h"
#include "tptp/TPTPSupportTypes.h"
#include "tptp/client/Constants.h"
#include "tptp/client/IProcess.h"
#include "tptp/TPTPUtils.h"
#include "DumpCmdHandler.h"

using namespace TPTP::Client;


/**
 *********************************************************
 *                                                       
 * @brief                                                
 *    Compatibility Client
 *
 *********************************************************/
int main(int argc, char* argv[])
{
	int rc = 0 ;
	char* hostName = "localhost";
	int portNum = 10006;
	INode* CompNode = 0;
	AgentController* ACProxy = 0;

	unsigned char binaryData[] = { 0,1,2,3,4,5,6,7,8,9 };
	char          *binaryDataStr;
	

	//Create a Node that represents the Target Machine
	CompNode = NodeFactory::createNode(hostName);

	//Connect to the Node
	printf( "\nConnecting to the Node...\n\n" );
	//Get the Agent Controller Proxy on the Node
	ACProxy = CompNode->connect(portNum);

	if (ACProxy != 0)
	{
		//Get an Agent - DumpAgent in this case
		Agent* DumpAgent = new Agent("org.eclipse.tptp.legacy.DumpAgent");
		ACProxy->getAgent(DumpAgent, TPTP_CONTROLLER_ACCESS);
		printf( "\nThe Dump Agent ID: %d\n\n", DumpAgent->getAgentID() );

		// Say hello to the Agent
		char	tempbuf[1024];
		sprintf(tempbuf, "<customCommand iid=\"org.eclipse.tptp.legacy\"><message>%s</message></customCommand>", "Hello Agent");

		DumpCommandHandler* cmdHandler = new DumpCommandHandler();
		DumpAgent->sendCommand(tempbuf, cmdHandler);

#ifdef TPTP_BASE64_ENCODING_IMPLEMENTED
		// Invoke the binary custom command
		int len = tptp_encodeBase64(binaryData, 10, NULL, 0);
		binaryDataStr = (char*)tptp_malloc(sizeof(char) * len);
		tptp_encodeBase64( binaryData, 10, binaryDataStr, len );
		sprintf(tempbuf, "<binaryCustomCommand iid=\"org.eclipse.tptp.legacy\"><message>%s</message></binaryCustomCommand>", binaryDataStr);
		DumpAgent->sendCommand(tempbuf, cmdHandler);
		tptp_free(binaryDataStr);
#endif /* TPTP_BASE64_ENCODING_IMPLEMENTED */

		
		//Establish Data Path and Data Listener
		DumpDataProcessor* dataProcessor = new DumpDataProcessor();
		printf( "Establish the Data Channel Path with the Dump Collector Agent...\n" );
		DumpAgent->createDataConnection(2);
		int dataConnectionID = DumpAgent->addDataListener(dataProcessor);

		printf( "Wait for few seconds before sending a custom command...\n" );
		Sleep(5000);

		// Stop monitoring the agent
// TODO:		DumpAgent->releaseDataConnection();

		// Invoke the custom command again
		sprintf(tempbuf, "<customCommand iid=\"org.eclipse.tptp.legacy\"><message>%s</message></customCommand>", "What about now?");
		DumpAgent->sendCommand(tempbuf, cmdHandler);

		printf( "Wait for few seconds before stopping the DumpAgent...\n" );
		while(1){Sleep(5000);};
		Sleep(5000);

		// Release the Dump collector 
		DumpAgent->releaseAgent();
		
		delete DumpAgent;

		ACProxy->destroy();

		NodeFactory::deleteNode(CompNode);
		
		printf( "All finished\n" );
	}
	else
	{
		printf( "ERROR: Unable to connect to the Agent Controller running on %s at port number %d\n", hostName, portNum );
	}

	while(1){Sleep(5000);};

	return 0;
}


