
################################################################################
#                                       
#  makefile:  client project            
#                                       
# $Id: CompClient_zos.make,v 1.1 2009/08/26 14:46:15 jwest Exp $                                  
################################################################################


#-----------------------------------
#
#   Customizable section
#
#-----------------------------------
TARGET         :=  CompClient
TARGETDIR      :=  ../../bin


#-----------------------------------
#   list of additional INCLUDE directories to search headers from
#      (separated by blanks)
#-----------------------------------
INCLUDEDIRS    :=  . ../../include


#-----------------------------------
#   list of additional libraries to be linked with
#      (separated by blanks)
#-----------------------------------
LIBS       :=  uuid dl tptpClient tptpUtils hcclco hcclsm hccls tptpConfig processControlUtil

#-----------------------------------
#   list of additional library directories to search from
#      (separated by blanks)
#-----------------------------------
LIBDIRS    :=  ../../lib ${XERCESC_HOME}/lib


#-----------------------------------
#
#   Compiler options
#
#      -g       produce debug info
#      -Wall    enable all types of warnings
#      -O3      highest level of code optimization
#      -fPIC    generate position-independent code (PIC).
#               This is required for building shared library.
#      -c       compile only
#
#   Linking options
#
#       -Wl       pass options to linker
#       -shared   produce shared library
#       -L        add the given directory to the search path for libraries
#
#-----------------------------------

CFLAGS     :=  $(C_FLAGS) $(DEBUGABLE) -Wall $(OPTIMIZABLE) -fPIC $(addprefix -I,$(INCLUDEDIRS))  -D_LINUX_X86

CXXFLAGS   :=  $(CFLAGS)

LINKOPTS   :=  $(L_FLAGS) $(DEBUGABLE) -o $(TARGETDIR)/$(TARGET) $(addprefix -L,$(LIBDIRS))


#-----------------------------------
#   general commands and options
#-----------------------------------

CC          :=  g++
CXX         :=  $(CC)

SOURCE     :=  $(wildcard *.cpp)

OBJS       :=  $(patsubst %.cpp,%.o,$(SOURCE))

REMOVEFILE :=  rm -f
CREATELINK :=  ln -sf


#-----------------------------------
#   "make" rules
#-----------------------------------

.PHONY : default everything objs clean veryclean rebuild $(TARGET)


default : $(TARGET)


objs : $(OBJS)


clean :
	$(REMOVEFILE) *.o


veryclean: clean
	$(REMOVEFILE) $(TARGETDIR)/$(TARGET)

rebuild: veryclean everything


$(TARGET) : $(OBJS)
	$(CC) $(LINKOPTS) $(OBJS) $(addprefix -l,$(LIBS))

