/*******************************************************************************
 * Copyright (c) 2005 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu K Naikawadi, Intel - Initial API and Implementation
 *
 * $Id: DumpDataProcessor.cpp,v 1.3 2005/10/05 17:09:23 akaylor Exp $
 *
 *******************************************************************************/ 


#include <iostream>
#include <memory.h>

#include "DumpDataProcessor.h"


DumpDataProcessor::DumpDataProcessor()
{
	//cout<<"DumpDataProcessor Constructor"<<endl;
}



DumpDataProcessor::~DumpDataProcessor()
{

}


/**
 * Handle the data coming 
 */
void DumpDataProcessor::incomingData(char buffer[], int length, DIME_HEADER_PTR_T dimeHeader)
{
	char dataStr[256] = "";
	int  maxDisplay;
	int  i;

	if ( length > 4 )
	{
		maxDisplay = 4;
	}
	else
	{
		maxDisplay = length;
	}

	for ( i = 0; i < maxDisplay; i++ )
	{
		char entry[32];

		if ( i == maxDisplay-1 )
			sprintf( entry, "%u...\n", (unsigned int)(unsigned char)buffer[i] );
		else
			sprintf( entry, "%u, ", (unsigned int)(unsigned char)buffer[i] );
		strcat( dataStr, entry );
	}


	printf( "DumpDataProcessor::incomingData() called\nData received is ----- %s", dataStr );
}


/**
 * Invalid Data Type
 */
void DumpDataProcessor::invalidDataType(char data[], int length)
{
	printf( "DumpDataProcessor::invalidDataType() called\n" );

}
/**
 * Waiting for data
 */
void DumpDataProcessor::waitingForData()
{

	printf( "DumpDataProcessor::waitingForData() called\n" );

}


