/*******************************************************************************
 * Copyright (c) 2005, 2006 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu K Naikawadi, Intel - Sample implementation of a client that launches
 *								  an application which requires console input/output.
 *
 * $Id: ConsoleTestClient.cpp,v 1.5 2006/10/26 22:11:04 kcallaghan Exp $
 *
 *******************************************************************************/ 

#include <iostream>
#include <stdlib.h>
#include <stdio.h>
using namespace std;

#include "tptp/client/NodeFactory.h"
#include "tptp/client/Collector.h"
#include "TimeDataProcessor.h"

using namespace TPTP::Client;

/**
 *********************************************************
 *                                                       
 * @brief                                                
 *    Client for launching an application that needs console I/O.
 *
 *********************************************************/
int main(int argc, char* argv[])
{
	int rc = 0 ;
	char* hostName = "localhost";
	int portNum = 10006;
	INode* TargetNode = 0;
	AgentController* ACProxy = 0;

	if ((argc == 2) || (argc > 3))
	{
		cout<<"Usage: ConsoleTestClient or ConsoleTestClient <HostName> <Port> "<<endl;
		cout<<"Press any key to exit..."<<endl;
		getchar();
		return -1;
	}

	// Use the host name and port number if provided on the command line.
	if (argc == 3)
	{
		hostName = argv[1];
		portNum = atoi(argv[2]);
	}
	// Create a Node object for the target system.
	TargetNode = NodeFactory::createNode(hostName);
	if (!TargetNode)
	{
		cout<<"ERROR: Failed to create the Node object."<<endl;
		cout<<"Press any key to exit..."<<endl;
		getchar();
		return -1;
	}

	// Establish a connection with an Agent Controller on the
	// target system.  The port number specified must match
	// that defined in the configuration file for the desired
	// Agent Controller.
	ACProxy = TargetNode->connect(portNum);
	
	if (!ACProxy)
	{
		cout<<"ERROR: Unable to connect to the Agent Controller running on "<<hostName<<" at port number "<<portNum<<endl;
		cout<<"Press any key to exit..."<<endl;
		getchar();
		return -1;
	}

	
	cout<<endl<<"Connected to the Agent Controller on \""<<hostName<<"\" at port number "<<portNum<<endl;

	// Create an instance of an IProcess object, populating it with the
	// launch parameters for the executable to be launched.
	// The executable name is SimpleAppl and the full pathname must be given.

#ifdef _WIN32
	char *appName= ".\\SimpleAppl.exe";
#else
	char *appName= "./SimpleAppl";
#endif
	cout<<endl<<"Preparing to launch app:\""<<appName<<"\""<<endl;
	IProcess* aProcess = ACProxy->createNewProcess();
	aProcess->setExecutable(appName);
	aProcess->setLocation(".");	

	// Setup the console data handler.  In this case, the TimeDataProcessor is used
	// which simply echoes the incoming data.
	IConsole* aProcessConsole = aProcess->getConsole();
	aProcessConsole->setDataProcessor(new TimeDataProcessor());

	// Launch the executable.
	// SimpleAppl writes to stdout and stderr, then reads from stdin.	
	aProcess->launch();

	// Write a message to the console input so that the application
	// has something to read.  This message should be read and displayed
	// by the application.
	aProcessConsole->write("This is console input to SimpleAppl.\n");

	cout<<"Wait for finished message, then Press any key to exit..."<<endl;
	getchar();
	
	// Release resources allocated by the Agent Controller
	ACProxy->disconnect();
	
	// Release client side resources
	ACProxy->destroy();
	NodeFactory::deleteNode(TargetNode);


	return 0;
}


