/*******************************************************************************
 * Copyright (c) 2005, 2009 Intel Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu K Naikawadi, Intel - Sample implementation of IDataProcessor for
 *								  handling data coming from TimeCollector agent.
 *
 * $Id: TimeDataProcessor.cpp,v 1.5 2009/09/10 21:17:41 jcayne Exp $
 *
 *******************************************************************************/ 

#include <iostream>
#include <memory.h>

#include <stdlib.h>

#include "TimeDataProcessor.h"

using namespace std;

TimeDataProcessor::TimeDataProcessor()
{

}

TimeDataProcessor::~TimeDataProcessor()
{

}

/**
 * Handle incoming data. 
 */
void TimeDataProcessor::incomingData(char buffer[], int length, DIME_HEADER_PTR_T dimeHeader)
{
	char *bufferCopy;

	// Make a copy of the data for our use.
	// Not required here, since it is simply displayed.
	bufferCopy = (char*)malloc(length+1);
	memcpy(bufferCopy, buffer, length);
	bufferCopy[length] = '\0';

	cout<<"Incoming data: "<<bufferCopy<<endl<<endl;
	free(bufferCopy);
}


/**
 * Handle invalid data type
 */
void TimeDataProcessor::invalidDataType(char data[], int length)
{
	cout<<endl<<"ERROR: Invalid data type received on data channel"<<endl;
}

/**
 * Wait for data
 */
void TimeDataProcessor::waitingForData()
{
	cout<<endl<<"Waiting for data ..."<<endl;
}


