
################################################################################
#                                           
#  makefile:  SimpleAppl project 
#                                           
# $Id                                
################################################################################


#-----------------------------------
#
#   Customizable section
#
#-----------------------------------
TARGET         :=  SimpleAppl
TARGETDIR      :=  ../../bin
 

#-----------------------------------
#   list of additional INCLUDE directories to search headers from
#      (separated by blanks)
#-----------------------------------
INCLUDEDIRS    :=  . 


#-----------------------------------
#   list of additional libraries to be linked with
#      (separated by blanks)
#-----------------------------------
LIBS       :=  

#-----------------------------------
#   list of additional library directories to search from
#      (separated by blanks)
#-----------------------------------
LIBDIRS    :=  .


#-----------------------------------
#
#
#      -g       produce debug info
#      -Wall    enable all types of warnings
#      -O3      highest level of code optimization
#      -fPIC    generate position-independent code (PIC).
#               This is required for building shared library.
#      -c       compile only
#
#   Linking options
#
#       -Wl       pass options to linker
#       -shared   produce shared library
#       -L        add the given directory to the search path for libraries
#
#-----------------------------------

CFLAGS     :=  $(C_FLAGS) $(DEBUGABLE) $(DEBUGFLAGS) -qflag=i:i $(SIXTYFOURBIT) $(OPTIMIZABLE) -qpic=large $(addprefix -I,$(INCLUDEDIRS))  -D_AIX

CXXFLAGS   :=  $(CFLAGS)

LINKOPTS   :=  $(L_FLAGS) $(DEBUGABLE) $(DEBUGLIBS) -brtl $(SIXTYFOURBIT) -o $(TARGETDIR)/$(TARGET) $(addprefix -L,$(LIBDIRS))


#-----------------------------------
#   general commands and options
#-----------------------------------

CC          :=  xlc_r
CXX         :=  $(CC)

SOURCE     :=  $(wildcard *.c)  $(wildcard *.cpp)

OBJS       :=  $(patsubst %.c,%.o,$(patsubst %.cpp,%.o,$(SOURCE)))

REMOVEFILE :=  rm -f
CREATELINK :=  ln -sf


#-----------------------------------
#   "make" rules
#-----------------------------------

.PHONY : default everything objs clean veryclean rebuild $(TARGET)


default : $(TARGET)


objs : $(OBJS)


clean :
	$(REMOVEFILE) *.o


veryclean: clean
	$(REMOVEFILE) $(TARGETDIR)/$(TARGET)

rebuild: veryclean everything


$(TARGET) : $(OBJS)
	$(CC) $(LINKOPTS) $(OBJS) $(addprefix -l,$(LIBS))
