/*******************************************************************************
 * Copyright (c) 2005, 2010 Intel Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu K Naikawadi, Intel - Header file for sample Collector agent.
 *
 * $Id: TimeCollector.h,v 1.13 2010/05/22 03:25:10 jcayne Exp $
 *
 *******************************************************************************/ 

#ifndef  TimeCollector_H
#define  TimeCollector_H

#include "tptp/agents/BaseCollectorImpl.h"

class TimeCollector : public BaseCollectorImpl
{
	private:
#ifdef _WIN32
		time_t startTime; // Time values in seconds
		time_t endTime;	
		time_t elapsedTime;
#elif defined _AIX
		time_t startTime;
		time_t endTime;
		time_t elapsedTime;
#else
		long startTime; // Time values in seconds
		long endTime;	
		long elapsedTime;
#endif
		bool running;	// Internal state variable.
		int  dataListenerID;

		int receiveData(int sourceID, char buffer[], int bytesRead, DIME_HEADER_PTR_T dimeHeader);

#ifdef _WIN32
		static DWORD WINAPI runThreadWin32(LPVOID param);
#else
		static void *runThreadNonWin32(void* param);
#endif

	public:

		TimeCollector(char* agentName);
		~TimeCollector();
		virtual int processCommand(CmdBlock* cmdBlock);
		void runThread();

		// Collector interface commands.
		int run(CmdBlock* cmdBlock);
		int stop(CmdBlock* cmdBlock);

		// TimeCollector interface commands.
		int getCurrentTime(CmdBlock* cmdBlock);
		int getElapsedTime(CmdBlock* cmdBlock);
};

#endif

