
################################################################################
#                                       
#  makefile:  TimeCollector project     
#                                       
# $Id: TimeCollector_solaris.make,v 1.2 2009/04/21 18:31:29 jwest Exp $                                  
################################################################################


#-----------------------------------
#
#   Customizable section
#
#-----------------------------------
TARGET         :=  TimeCollector
TARGETDIR      :=  ../../bin


#-----------------------------------
#   list of additional INCLUDE directories to search headers from
#      (separated by blanks)
#-----------------------------------
INCLUDEDIRS    :=  . ../../include


#-----------------------------------
#   list of additional libraries to be linked with
#      (separated by blanks)
#-----------------------------------
LIBS       :=  uuid dl Cstd tptpAgentBase tptpUtils processControlUtil transportSupport pthread tptpLogUtils tptpConfig transportSupport hcclco hcclsm hccls Crun 


#-----------------------------------
#   list of additional library directories to search from
#      (separated by blanks)
#-----------------------------------
LIBDIRS    :=  ../../lib /opt/sunstudio11/SUNWspro/lib/ /usr/lib/
DEFINES := -D_SOLARIS -DENW -DSQLUNIX -DSOLARIS -D_REENTRANT -D__suncc42

#-----------------------------------
#
#   Compiler options
#
#      -g       produce debug info
#      -Wall    enable all types of warnings
#      -O3      highest level of code optimization
#      -fPIC    generate position-independent code (PIC).
#               This is required for building shared library.
#      -c       compile only
#
#   Linking options
#
#       -Wl       pass options to linker
#       -shared   produce shared library
#       -L        add the given directory to the search path for libraries
#
#-----------------------------------

CFLAGS     :=  $(C_FLAGS) $(DEBUGABLE) $(OPTIMIZABLE) $(SIXTYFOURBIT) $(LIBLOCATION) -xCC -KPIC $(addprefix -I,$(INCLUDEDIRS))  $(DEFINES)

CXXFLAGS   :=  $(CFLAGS)

LINKOPTS   :=  $(L_FLAGS) $(DEBUGABLE) $(SIXTYFOURBIT) $(LIBLOCATION) -mt -dy -z nodefs -L../../lib -o $(TARGETDIR)/$(TARGET) $(addprefix -L,$(LIBDIRS))


#-----------------------------------
#   general commands and options
#-----------------------------------

CC          :=  cc
CXX         :=  CC

SOURCE     :=  $(wildcard *.cpp)

OBJS       :=  $(patsubst %.cpp,%.o,$(SOURCE))

REMOVEFILE :=  rm -f
CREATELINK :=  ln -sf


#-----------------------------------
#   "make" rules
#-----------------------------------

.PHONY : default everything objs clean veryclean rebuild $(TARGET)


default : $(TARGET)


objs : $(OBJS)


clean :
	$(REMOVEFILE) *.o


veryclean: clean
	$(REMOVEFILE) $(TARGETDIR)/$(TARGET)
	

rebuild: veryclean everything


$(TARGET) : $(OBJS)
	$(CXX) $(LINKOPTS) $(OBJS) $(addprefix -l,$(LIBS))


