
################################################################################
#                                       
#  makefile:  ChkPass project   
#                                       
# $Id: ChkPass_solaris.make,v 1.2 2009/11/21 22:27:20 jwest Exp $                                  
################################################################################

ifeq ($(shell uname -m), i86pc)
	SOLARIS_X86=1
endif


#-----------------------------------
#
#   Customizable section
#
#-----------------------------------
TARGET :=  ChkPass
TARGETDIR :=  ../../bin


#-----------------------------------
#   list of additional INCLUDE directories to search headers from
#      (separated by blanks)
#-----------------------------------
INCLUDEDIRS := 


#-----------------------------------
#   list of additional libraries to be linked with
#      (separated by blanks)
#-----------------------------------
ifdef SOLARIS_X86
	LIBS := Crun
else
	LIBS := crypt Crun
endif



#-----------------------------------
#   list of additional library directories to search from
#      (separated by blanks)
#-----------------------------------
LIBDIRS :=

ifdef SOLARIS_X86
	LIBDIRS += /usr/lib/amd64 
endif

#-----------------------------------
#
#   Compiler options
#
#      -g       produce debug info
#      -Wall    enable all types of warnings
#      -O3      highest level of code optimization
#      -fPIC    generate position-independent code (PIC).
#               This is required for building shared library.
#      -c       compile only
#
#   Linking options
#
#       -Wl       pass options to linker
#       -shared   produce shared library
#       -L        add the given directory to the search path for libraries
#
#-----------------------------------
DEFINES := -DENW -DSQLUNIX -DSOLARIS -D_REENTRANT -D__suncc42

ifdef SOLARIS_X86
	DEFINES += -D_SOLARISX86 
else
	DEFINES += -D_SOLARIS
endif


CFLAGS     :=  $(C_FLAGS) $(DEBUGABLE) $(SIXTYFOURBIT) $(LIBLOCATION) $(OPTIMIZABLE) -xCC -KPIC $(addprefix -I,$(INCLUDEDIRS)) -D_TPTP_DIAGNOSTIC_ $(DEFINES)

CXXFLAGS   :=  $(CFLAGS)

LINKOPTS   :=  $(L_FLAGS) $(DEBUGABLE) $(SIXTYFOURBIT) $(LIBLOCATION) -mt -dy -z nodefs -L../../lib -o $(TARGETDIR)/$(TARGET) $(addprefix -L,$(LIBDIRS))


#-----------------------------------
#   general commands and options
#-----------------------------------

CC          :=  cc
CXX         :=  CC

SOURCE      :=  $(wildcard *.c) $(wildcard *.cpp)

OBJS        :=  $(patsubst %.c,%.o,$(patsubst %.cpp,%.o,$(SOURCE)))

REMOVEFILE :=  rm -f
CREATELINK :=  ln -sf


#-----------------------------------
#   "make" rules
#-----------------------------------

.PHONY : default everything objs clean veryclean rebuild $(TARGET)


default : $(TARGET)


objs : $(OBJS)


clean :
	$(REMOVEFILE) *.o

veryclean: clean
	$(REMOVEFILE) $(TARGETDIR)/$(TARGET)

rebuild: veryclean everything


$(TARGET) : $(OBJS)
	$(CC) $(LINKOPTS) $(OBJS) $(addprefix -l,$(LIBS))
