
################################################################################
#                                       
#  makefile:  ChkPass project   
#                                       
# $Id: ChkPass_zos.make,v 1.1 2009/08/26 14:46:11 jwest Exp $                                  
################################################################################


#-----------------------------------
#
#   Customizable section
#
#-----------------------------------
TARGET :=  ChkPass
TARGETDIR :=  ../../bin


#-----------------------------------
#   list of additional INCLUDE directories to search headers from
#      (separated by blanks)
#-----------------------------------
INCLUDEDIRS := 


#-----------------------------------
#   list of additional libraries to be linked with
#      (separated by blanks)
#-----------------------------------
LIBS :=


#-----------------------------------
#   list of additional library directories to search from
#      (separated by blanks)
#-----------------------------------
LIBDIRS :=


#-----------------------------------
#
#   Compiler options
#
#      -g       produce debug info
#      -Wall    enable all types of warnings
#      -O3      highest level of code optimization
#      -fPIC    generate position-independent code (PIC).
#               This is required for building shared library.
#      -c       compile only
#
#   Linking options
#
#       -Wl       pass options to linker
#       -shared   produce shared library
#       -L        add the given directory to the search path for libraries
#
#-----------------------------------

CXXFLAGS   :=  $(C_FLAGS) $(DEBUGABLE) $(DEBUGFLAGS) -qflag=i $(OPTIMIZABLE) $(addprefix -I,$(INCLUDEDIRS)) -D_OS390 -D_UNIX03_THREADS -DMVS=1 -D_XOPEN_SOURCE_EXTENDED=1 -D_POSIX_SOURCE -D_TPTP_DIAGNOSTIC_ -W c,$(SIXTYFOURBIT)CSECT,NOLOCALE,LANGLVL\(EXTENDED\),LONGNAME,DLL,TARGET\(zOSV1R9\),XPLINK

CFLAGS     :=  $(CXXFLAGS),SSCOMM,RENT

LINKOPTS   :=  $(L_FLAGS) $(DEBUGABLE) $(DEBUGLIBS) -W l,$(SIXTYFOURBIT)XPLINK,AMODE=$(AMODEBIT),RMODE=ANY,CALL,REUS=RENT -o $(TARGETDIR)/$(TARGET) $(addprefix -L,$(LIBDIRS))


#-----------------------------------
#   general commands and options
#-----------------------------------

CC          :=  xlc
CXX         :=  $(CC)

SOURCE      :=  $(wildcard *.c) $(wildcard *.cpp)

OBJS        :=  $(patsubst %.c,%.o,$(patsubst %.cpp,%.o,$(SOURCE)))

REMOVEFILE :=  rm -f
CREATELINK :=  ln -sf


#-----------------------------------
#   "make" rules
#-----------------------------------

.PHONY : default everything objs clean veryclean rebuild $(TARGET)


default : $(TARGET)


objs : $(OBJS)


clean :
	$(REMOVEFILE) *.o *.dbg

veryclean: clean
	$(REMOVEFILE) $(TARGETDIR)/$(TARGET)

rebuild: veryclean everything


$(TARGET) : $(OBJS)
	$(CC) $(LINKOPTS) $(OBJS) $(LIBS)
