/*******************************************************************************
 * Copyright (c) 2005 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Andy Kaylor, Intel - Initial implementation
 *
 * $Id: CmdExtractor.h,v 1.5 2005/09/19 21:37:40 akaylor Exp $
 *******************************************************************************/ 

#ifndef __CMDEXTRACTOR_H__
#define __CMDEXTRACTOR_H__

#include "tptp/Extractor.h"

#ifdef __cplusplus
extern "C"
{
#endif

typedef struct
{
	struct
	{
		tptp_object*          cmo;
		processCommand_ptr_t  processCommand;
		logEventEntry_ptr_t   logEvent;
	} ac;
} cx_state_data;


/* Declared here, but implemented in MsgParser.cpp */
void initializeParser();
unsigned int parseMessage( cx_state_data* cx, const char *msg );

#define COMMAND_EXTRACTOR_ID 30001

#ifdef __cplusplus
}
#endif

#endif /* __CMDEXTRACTOR_H__ */

