/*******************************************************************************
 * Copyright (c) 2005 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Andy Kaylor, Intel - Initial implementation
 *
 * $Id: MsgParser.h,v 1.4 2005/09/12 18:02:03 akaylor Exp $
 *******************************************************************************/ 

#include "CmdExtractor.h"

#ifdef USE_SAX
#include <xercesc/sax/HandlerBase.hpp>

XERCES_CPP_NAMESPACE_USE

class MsgSAXHandler : public HandlerBase 
{
public:
	MsgSAXHandler();
	~MsgSAXHandler();

    void startElement(const XMLCh* const elem, AttributeList& attr);
	void endElement(const XMLCh* const name);
	void characters(const XMLCh* const chars,
	                const unsigned int length);
    void fatalError(const SAXParseException& e);

	void setCmdExtractor( cx_state_data* cx ) { m_cx = cx; }
	void setMaxLen( int maxLen ) { m_maxLen = maxLen; }
private:
	cx_state_data* m_cx;
	int            m_maxLen;
	unsigned int   m_destID;
	char*          m_cmd;
};
#endif

