/**********************************************************************
Copyright (c) 2005, 2007 IBM Corporation and others.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Eclipse Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/epl-v10.html
$Id: launcher_common.c,v 1.2 2007/04/05 23:54:29 jkubasta Exp $

Contributors:
 IBM Corporation - initial implementation
**********************************************************************/

#include "launcher_common.h"


/** START_PROCESS ***************************************************
  * This function lauches a process on the current OS.  Using the
  * specified execuatble and arguments it checks the server configuration
  * to determine if the specified process is allowed to be launched, and
  * if so, creates the specified environment for the process before it
  * is launched
  */
PID hc_startProcess(char *exe, char *cmdline, char *location, char *env, RemoteConsole_t *console) {
	PID childPID;
	RA_HANDLE consoleChild[3];

	/* Set the console to be NULL initially */
	console->in = RA_HANDLE_NULL;
	console->out = RA_HANDLE_NULL;
	console->err = RA_HANDLE_NULL;
	consoleChild[0] = RA_HANDLE_NULL; /* in */
	consoleChild[1] = RA_HANDLE_NULL; /* out */
	consoleChild[2] = RA_HANDLE_NULL; /* err */

	/* When a process is launched through this mechanism we would like to
	   capture the remote console information to be transported to the remote
	   monitor.
	*/
	if(!ra_createPipe(&consoleChild[0], &console->in)) {
		printf("Error creating stdin pipe\n");
	}
	if(!ra_createPipe(&console->out, &consoleChild[1])) {
		printf("Error creating stdout pipe\n");
	}
	if(!ra_createPipe(&console->err, &consoleChild[2])) {
		printf("Error creating stderr pipe\n");
	}

	/* Launch the process */
	childPID = hc_launchProcess(exe, cmdline, location, env, consoleChild);

	return childPID;
}
