/**********************************************************************
Copyright (c) 2005, 2009 IBM Corporation and others.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Eclipse Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/epl-v10.html
$Id: launcher_common.h,v 1.4 2009/07/10 00:11:37 jwest Exp $

Contributors:
 IBM Corporation - initial implementation
**********************************************************************/

#ifndef _LAUNCHER_H_
#define _LAUNCHER_H_

#define MAX_ARGS 64
#define MAX_ENV 512

#include "RAComm.h"
#include "hclaunch.h"
#include "launcher_md.h"
#include "launcher_error.h"
#include <stdio.h>

#include <stdlib.h>

/*
 * The structure that contains information regarding a console connection
 */
typedef struct {
	RA_HANDLE remote;
	RA_HANDLE in;
	RA_HANDLE out;
	RA_HANDLE err;
} RemoteConsole_t;


/* Copyright */
static char *kCBIBMCopyright="(c) Copyright IBM Corporation 2000,2001";

/** START_PROCESS ***************************************************
  * This function lauches a process on the current OS.  Using the
  * specified executable and arguments it checks the server configuration
  * to determine if the specified process is allowed to be launched, and
  * if so, creates the specified environment for the process before it
  * is launched.
  * @param               exe - the alias name of the process to launch.
  * @param              args - the arguments for the process.
  * @param          location - the directory to launch the process in.
  * @param   remoteCOnsoleIP - the IP address of the remote console.
  * @param remoteConsolePort - the port of the remote console.
  * @param  finalEnvironment -the hc_array_t structure to recieve the process environment.
  */
PID hc_startProcess(char *exe,
					char *cmdline,
					char *location,
					char *env,
					RemoteConsole_t *console);

#endif
