/**********************************************************************
Copyright (c) 2005, 2009 IBM Corporation and others.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Eclipse Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/epl-v10.html
$Id: launcher_md.h,v 1.3 2009/07/10 00:11:37 jwest Exp $

Contributors:
 IBM Corporation - initial implementation
**********************************************************************/


/* MACRO's to simplify the JNI code. */
#if defined __cplusplus && defined _HPUX
	#define ENV(e) e
	#define ENVPARM(e)
#else
	#define ENV(e) (*e)
	#define ENVPARM(e) e,
#endif


#ifdef _WIN32
	#include <winsock2.h> /* Bug 134924 */
	#include <windows.h>
	#include <io.h>
	#include <process.h>
#else
	#ifdef __OS400__
		#include "launcher_os400.h"
	#endif
	#include <errno.h>
	#include <signal.h>
	#include <unistd.h>
	#include <sys/wait.h>
	#include <stdlib.h>
	extern char **environ;
#endif


/*
 * Platform-dependent functions
 */
#ifdef _WIN32
PID hc_launchProcess_WIN32(char *exe, char *args, char *location, char *env, RA_HANDLE consoleChild[]);

#elif MVS
PID hc_launchProcess_MVS(char *exe, char *args, char *location, char *env, RA_HANDLE consoleChild[]);

#elif __OS400__
PID hc_launchProcess_OS400(char *exe, char *args, char *location, char *env, RA_HANDLE consoleChild[]);

#else
PID hc_launchProcess_UNIX(char *exe, char *args, char *location, char *env, RA_HANDLE consoleChild[]);

#endif


/*
 * Common functions
 */
void* hc_getEnvironment();
int hc_getEnvironmentVariable(void *env, int offset, char **name, char **value );
int hc_getProcessStatus(PID pid);
void  hc_killProcess(int pid);
PID   hc_launchProcess(char *exe, char *args, char *location, char *env, RA_HANDLE consoleChild[]);
int   hc_readFile(RA_HANDLE fd, char* buffer, int count);
int   hc_writeFileChar(RA_HANDLE fd, char c);
