/*******************************************************************************
 * Copyright (c) 2005,2006 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Andy Kaylor, Intel - Initial implementation
 *
 * $Id: ACLog.h,v 1.3 2006/04/04 22:14:58 kcallaghan Exp $
 *
 *******************************************************************************/ 

#ifndef __ACLOG_H__
#define __ACLOG_H__

/*****************************************************************************************************
 *                                                                                                   *
 * To use the log macros in TPTPLog.h, the following must be defined:                                *
 *                                                                                                   *
 *    RESOLVE_LOG_EVENT_FUNC(p)      resolves to a logEvent function pointer                         *
 *    RESOLVE_INITIAL_PARAM(p)       if a parameter is needed before the subcomponent, this macro    *
 *                                     should give that parameter, including the separating comma    *
 *                                     if no such parameter is needed this macro should resolve to   *
 *                                   white space                                                     *
 *    TPTP_LOG_SUBCOMPONENT_NAME(p)  the name of the subcomponent to appear in the log file          *
 *    TPTP_LOG_INSTANCE_ID(p)        an instance ID for the log file                                 *
 *                                                                                                   *
 *****************************************************************************************************/

/* These definitions ignore 'p' and use global variables defined in AgentController.c  */
/* Note: This file should only be included from AgentController.c                      */

#define RESOLVE_LOG_EVENT_FUNC(p)     loggingService_logEvent
#define RESOLVE_INITIAL_PARAM(p)      &loggingService, /* Note: this trailing comma is required */
#define TPTP_LOG_SUBCOMPONENT_NAME(p) "Core"
#define TPTP_LOG_INSTANCE_ID(p)       0

/* Do not move this include, it requires the above definitions */
#include "tptp/TPTPLog.h"

#endif /* __ACLOG_H__ */

