
################################################################################
#                                       
#  makefile:  AgentController project   
#                                       
# $Id: AgentController_mac.make,v 1.1 2009/08/07 02:34:05 jwest Exp $                                  
################################################################################


#-----------------------------------
#
#   Customizable section
#
#-----------------------------------
TARGET         :=  ACServer
TARGETDIR      :=  ../../bin


#-----------------------------------
#   list of additional INCLUDE directories to search headers from
#      (separated by blanks)
#-----------------------------------

INCLUDEDIRS    :=  ../transport/RACommon ../transport/RASharedMemory ../transport/RASocket . ../../include ${XERCESC_HOME}/include


#-----------------------------------
#   list of additional libraries to be linked with
#      (separated by blanks)
#-----------------------------------

LIBS       :=  tptpUtils tptpLogUtils tptpConfig processControlUtil xerces-c pthread

#-----------------------------------
#   list of additional library directories to search from
#      (separated by blanks)
#-----------------------------------

LIBDIRS    :=  ../../lib ${XERCESC_HOME}/lib


#-----------------------------------
#
#   Compiler options
#
#      -g       produce debug info
#      -Wall    enable all types of warnings
#      -O3      highest level of code optimization
#      -fPIC    generate position-independent code (PIC).
#               This is required for building shared library.
#      -c       compile only
#
#   Linking options
#
#       -Wl       pass options to linker
#       -shared   produce shared library
#       -L        add the given directory to the search path for libraries
#
#-----------------------------------

CFLAGS     :=  $(C_FLAGS) $(DEBUGABLE) -Wall $(OPTIMIZABLE) -fPIC $(addprefix -I,$(INCLUDEDIRS)) -D_TPTP_DIAGNOSTIC_

CXXFLAGS   :=  $(CFLAGS)

LINKOPTS   :=  $(L_FLAGS) $(DEBUGABLE) -m $(addprefix -L,$(LIBDIRS)) -o $(TARGETDIR)/$(TARGET)


#-----------------------------------
#   general commands and options
#-----------------------------------

CC          :=  gcc
CXX         :=  g++

SOURCE      :=  $(wildcard *.c) $(wildcard *.cpp)

OBJS        :=  $(patsubst %.c,%.o,$(patsubst %.cpp,%.o,$(SOURCE)))

REMOVEFILE :=  rm -f
CREATELINK :=  ln -sf


#-----------------------------------
#   "make" rules
#-----------------------------------

.PHONY : default everything objs clean veryclean rebuild $(TARGET)


default : $(TARGET)


objs : $(OBJS)


clean :
	$(REMOVEFILE) *.o

veryclean: clean
	$(REMOVEFILE) $(TARGETDIR)/$(TARGET)

rebuild: veryclean everything


$(TARGET) : $(OBJS)
	$(CXX) $(LINKOPTS) $(OBJS) $(addprefix -l,$(LIBS))

