/*******************************************************************************
 * Copyright (c) 2005, 2006 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Andy Kaylor, Intel - Initial re-implementation of Agent Controller
 *
 * $Id: AgentManager.h,v 1.15 2006/02/14 17:55:02 akaylor Exp $
 *******************************************************************************/ 


#ifndef __AGENT_MANAGER_H__
#define __AGENT_MANAGER_H__

#include "tptp/TPTPUtils.h"
#include "tptp/TPTPTypes.h"
#include "tptp/TPTPCommon.h"
#include "tptp/TPTPConfigBinding.h"
#include "ACTypes.h"
#include "LoggingService.h"

typedef struct AgentManager_tag
{
	tptp_int32                       nextContextID;
	tptp_list_t                      agentList;
	tptp_list_t                      availableAgentList;
	tptp_list_t                      pendingAgentList;
	tptp_list_t                      eventListenerList;
    tptp_list_t                      globalOptionsList;
	Lock_t                           agentListLock;
	char                             defProcCtrlName[_MAX_PATH];
	struct agent_tag*                processControllerAgent;
	struct ConnectionManager_tag*    connectionManager;
	struct ConfigurationManager_tag* configurationManager;
	LoggingService_t*                loggingService;
} AgentManager_t;

tptp_int32  agentManager_processCommand( AgentManager_t* am, const char* cmd );
tptp_int32  agentManager_init( AgentManager_t* am );
tptp_int32  agentManager_cleanup( AgentManager_t* am );
tptp_int32  agentManager_startAutoloadAgents( AgentManager_t* am );
tptp_int32  agentManager_releaseResources( AgentManager_t* am, tptp_int32 ownerID );
tptp_int32  agentManager_setAvailableAgentList( AgentManager_t* am, tptp_list_t* availList );
tptp_int32  agentManager_setGlobalOptions( AgentManager_t* am, tptp_list_t* options );

void agentManager_setDefaultProcessController( AgentManager_t*am, char* procCtlrName );

#endif /* __AGENT_MANAGER_H__ */
