/*******************************************************************************
 * Copyright (c) 2005, 2010 Intel Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Andy Kaylor, Intel - Initial re-implementation of Agent Controller
 * $Id: AgentManagerPrivate.h,v 1.25 2010/12/23 20:35:06 jwest Exp $
 *******************************************************************************/ 

#ifndef __AGENTMANAGERPRIVATE_H__
#define __AGENTMANAGERPRIVATE_H__

#include "tptp/TPTPTypes.h"
#include "tptp/ACFlags.h"
#include "tptp/TPTPConfigBinding.h"

typedef struct agent_tag 
{
	tptp_int32   agentID;
	PID          processID;
	char         agentName[256];
	tptp_int32   locked;
	tptp_int32   refCount;
	tptp_list_t  controllers;
	tptp_list_t  observers;
	const agent_metadata_t*  metadata;
} agent_t;

typedef struct
{
	PID           processID;
	tptp_int32    processLaunchContext;
	tptp_int32    requestorID;
	tptp_int32    requestFlag;
	tptp_int32    requestContext;
	char   agentName[256];
} pending_agent_t;

/* Internal function declarations */
tptp_int32 agentManager_processCommandImpl( AgentManager_t* am, 
                                            const char*     cmd, 
		                                    tptp_int32      sourceID, 
		                                    tptp_int32      context,
		                                    const char*     interfaceID, 
		                                    const char*     cmdName, 
									        tptp_list_t*    paramList );

tptp_int32 agentManager_registerAgent( AgentManager_t* am, 
                                       tptp_int32      sourceID, 
                                       tptp_int32      context, 
                                       tptp_int32      agentID,
                                       PID             processID,
                                       const char*     agentName );

tptp_int32 agentManager_deregisterAgent( AgentManager_t* am, 
                                         tptp_int32      sourceID, 
                                         tptp_int32      context, 
                                         tptp_int32      agentID );

tptp_int32 agentManager_queryAvailableAgents( AgentManager_t* am, 
                                              tptp_int32      sourceID, 
                                              tptp_int32      context, 
                                              tptp_list_t*    interfaces );			
                                       
tptp_int32 agentManager_queryRunningAgents( AgentManager_t* am, 
                                            tptp_int32      sourceID, 
                                            tptp_int32      context, 
                                            PID             processID, 
                                            tptp_list_t*    interfaces );			

tptp_int32 agentManager_getAgent( AgentManager_t* am, 
                                  tptp_int32      sourceID, 
                                  tptp_int32      context, 
                                  const char*     agentName, 
                                  tptp_int32      flags );

tptp_int32 agentManager_getAgentByID( AgentManager_t* am, 
                                      tptp_int32      sourceID, 
                                      tptp_int32      context, 
                                      tptp_int32      agentID, 
                                      tptp_int32      flags );

tptp_int32 agentManager_getAgentByToken( AgentManager_t* am, 
                                         tptp_int32      sourceID, 
                                         tptp_int32      context, 
                                         tptp_int32      token, 
                                         tptp_int32      flags );

tptp_int32 agentManager_requestControl( AgentManager_t* am, 
                                        tptp_int32      sourceID, 
                                        tptp_int32      context, 
                                        tptp_int32      agentID, 
                                        tptp_int32      flags );

tptp_int32 agentManager_releaseControl( AgentManager_t* am, 
                                        tptp_int32      sourceID, 
                                        tptp_int32      context, 
                                        tptp_int32      agentID );

tptp_int32 agentManager_releaseAgent( AgentManager_t* am, 
                                      tptp_int32      sourceID, 
                                      tptp_int32      context, 
                                      tptp_int32      agentID );

tptp_int32 agentManager_bindDataConnections( AgentManager_t* am, 
                                             tptp_int32      sourceID, 
                                             tptp_int32      context, 
                                             tptp_int32      dataConn1, 
                                             tptp_int32      dataConn2 );

tptp_int32 agentManager_getAgentMetadata( AgentManager_t* am, 
                                          tptp_int32      sourceID, 
                                          tptp_int32      context, 
                                          const char*     agentName );

tptp_int32 agentManager_getApplicationAliases( AgentManager_t* am, 
                                               tptp_int32      sourceID, 
                                               tptp_int32      context );

tptp_int32 agentManager_requestMonitor( AgentManager_t* am, 
                                        tptp_string*    rmi,
                                        tptp_string*    rai,
                                        tptp_int32      sourceID,
                                        tptp_int32      context );

tptp_int32 agentManager_requestMonitorLocal( AgentManager_t* am, 
                                             tptp_string*    peerConnectionInfo,
                                             agent_t*        agentToBeMontored,
                                             tptp_string*    incomingPeerAgentInfo,
                                             tptp_int32      sourceID,
                                             tptp_int32      context );

tptp_int32 agentManager_getPeerConnectionInfo( AgentManager_t* am, 
                                               tptp_string*    connectionType,
                                               tptp_int32      sourceID, 
                                               tptp_int32      context );

tptp_int32 agentManager_buildConnectionInfo( AgentManager_t* am, 
                                             tptp_string*    connectionType,
                                             tptp_string**   ci );

tptp_int32 agentManager_getPropertyList( AgentManager_t* am, 
                                         tptp_int32      sourceID, 
                                         tptp_int32      context, 
                                         tptp_string*    name, 
                                         tptp_string*    type );

tptp_int32 agentManager_addAgentEventListener( AgentManager_t* am, 
                                               const char*     eventIID, 
                                               const int       listenerID,
                                               const int       source, 
                                               const int       context);

tptp_int32 agentManager_removeAgentEventListener( AgentManager_t* am, 
                                                  const char*     eventIID, 
                                                  const int       listenerID,
                                                  const int       source, 
                                                  const int       context);

void agentManager_fireAgentEvent( AgentManager_t*     am, 
                                  const tptp_string*  eventName,
                                  const tptp_string*  agentName,
								  tptp_uint32         agentToken,
								  PID                 processID );

tptp_int32 agentManager_launchAgent( AgentManager_t* am, 
                                     const char*     launchInfo, 
                                     const char*     agentName, 
                                     tptp_int32      sourceID, 
                                     tptp_int32      context );

/* BUG 307787 */
tptp_int32 agentManager_queryACPathInfo( AgentManager_t* am,
                                     tptp_int32      sourceID,
                                     tptp_int32      context );
tptp_int32 agentManager_isAgentPathSupported( AgentManager_t* am,
                                              tptp_int32      sourceID,
                                              tptp_int32      context );

tptp_int32 agentManager_getACPlatform( AgentManager_t* am,
											  tptp_int32 sourceID,
											  tptp_int32 context );

tptp_int32 agentManager_getACHostTime( AgentManager_t* am,
											  tptp_int32 sourceID,
											  tptp_int32 context );

void agentManager_grantAgentReference( AgentManager_t* am, tptp_int32 dest, tptp_int32 context, agent_t* agent, tptp_int32 flags );
void agentManager_sendNotifyReference( AgentManager_t* am, tptp_int32 dest, tptp_int32 context, tptp_int32 clientID, tptp_int32 flags );

agent_t* agentManager_findActiveAgentByName( AgentManager_t* am, const char* agentName );
agent_t* agentManager_findActiveAgentByNameAndProcessID( AgentManager_t* am, const char* agentName, PID processID );
agent_t* agentManager_findActiveAgentByID( AgentManager_t* am, tptp_int32 agentID, BOOL purgeInactive );
agent_metadata_t* agentManager_findAgentMetadata( AgentManager_t* am, const char* agentName );

void agentManager_purgeAgentList( AgentManager_t* am );

tptp_int32 agentManager_addReference( AgentManager_t* am, agent_t* agent, tptp_int32 sourceID, tptp_int32 flags );
tptp_int32 agentManager_removeReference( AgentManager_t* am, agent_t* agent, tptp_int32 sourceID );

BOOL agentManager_checkAccess( AgentManager_t* am, agent_t* agent, tptp_int32 flags );
BOOL agentManager_checkInterfaces( AgentManager_t*    am, 
                                   const tptp_list_t* required, 
                                   const tptp_list_t* supported );

tptp_int32 agentManager_handleProcessStarted( AgentManager_t* am, tptp_int32 context, PID processID );
tptp_int32 agentManager_handleProcessExited( AgentManager_t* am, tptp_int32 context, PID processID, tptp_int32 exitCode );

agent_t* agentManager_getProcessController( AgentManager_t* am );
void agentManager_startProcessController( AgentManager_t* am );

tptp_int32 agentManager_notifyAgentUsers( AgentManager_t* am, agent_t* agent, char* notifyCmdName );

void agentManager_sendErrorResponse( AgentManager_t* am, tptp_int32 errorCode, tptp_int32 sourceID, tptp_int32 contextID );

/* This defines a bit mask that makes a token from an agent ID     */
/*   Components that have received tokens should NOT unmask this   */
/*   constant to convert tokens to agent IDs.  To get a legitimate */
/*   agent reference, components should use the getAgentByToken    */
/*   command                                                       */
#define AGENT_TOKEN_MASK 0x40000000

/* A function that lets us call the top-level shutdown */
tptp_int32 agentController_shutdown();

#endif /* __AGENTMANAGERPRIVATE_H__ */
