/*******************************************************************************
 * Copyright (c) 2005, 2007 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Andy Kaylor, Intel - Initial re-implementation of Agent Controller
 * 
 * $Id: ConfigurationManager.h,v 1.9 2007/05/05 02:26:11 samwai Exp $
 *******************************************************************************/ 

#ifndef __CONFIGURATIONMANAGER_H__
#define __CONFIGURATIONMANAGER_H__

#include "tptp/TPTPConfig.h"
#include "tptp/TPTPCommon.h"
#include "tptp/TPTPTypes.h"
#include "ACTypes.h"
#include "LoggingService.h"

/* Bug 175696 starts */
#if defined(_WIN32) || defined(_WIN64)
  /* No header needed */
#else
  #include <sys/types.h>
  #include <dirent.h>
  #include <errno.h>
#endif

BOOL isEnvironmentValid();

/* Bug 175696 ends */

typedef struct ConfigurationManager_tag
{
	char                           configDir[_MAX_PATH];
	AC_Config_t                    configData;
	struct AgentManager_tag*       agentManager;      /* defined in AgentManager.h        */
	struct ConnectionManager_tag*  connectionManager; /* defined in ConnectionManager.h   */
	LoggingService_t*              loggingService;
} ConfigurationManager_t;

tptp_int32 configurationManager_init( ConfigurationManager_t* cm );
tptp_int32 configurationManager_cleanup( ConfigurationManager_t* cm );
tptp_int32 configurationManager_setConfigDirectory( ConfigurationManager_t* cm, char *dir );
tptp_int32 configurationManager_readConfigFile( ConfigurationManager_t* cm );
tptp_int32 configurationManager_getApplicationAliases( ConfigurationManager_t* cm, tptp_string** aliases );
tptp_int32 configurationManager_getPeerConnectionTransport( ConfigurationManager_t* cm, tptp_string** pmt );

/* TODO: Add functions to access specific configuration settings */

#endif /* __CONFIGURATIONMANAGER_H__ */
