/*******************************************************************************
 * Copyright (c) 2005, 2006 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Andy Kaylor, Intel - Initial re-implementation of Agent Controller
 * $Id: ConnectionManager.h,v 1.14 2006/11/01 22:47:16 akaylor Exp $
 *******************************************************************************/ 

#ifndef __CONNECTIONMANAGER_H__
#define __CONNECTIONMANAGER_H__


#include "tptp/TPTPUtils.h"
#include "ACTypes.h"
#include "LoggingService.h"
#include "tptp/TPTPCommon.h"
#include "tptp/TPTPTypes.h"
#include "tptp/MsgPipeline.h"

/* 
 *  Because the connection manager is called from outside,
 *  we will not require this structure to be passed as a
 *  parameter to its methods. 
**/
typedef struct ConnectionManager_tag
{
	tptp_int32               nextTransportID;
	tptp_int32               nextConnectionID;
	tptp_int32               nextDataConnectionID;
	tptp_list_t              connectionList;
	tptp_list_t              dataConnectionList;
	tptp_list_t              messagePipelineList;
	PeerAttachInfo_t         peerInfo;
	struct AgentManager_tag* agentManager;
	LoggingService_t*        loggingService;
	tptp_object              cmo;
} ConnectionManager_t;

/* Called during initialization to open our ears */
tptp_int32 connectionManager_init( ConnectionManager_t* cm );
tptp_int32 connectionManager_createMessagePipeline( ConnectionManager_t* cm,
                                                    const char*          transportLayer,
                                                    const char*          transportType,
                                                    const char*          tlConfigBlock,
                                                    const char*          commandExtractor );
tptp_int32 connectionManager_startServers( ConnectionManager_t* cm  );
tptp_int32 connectionManager_stopServers( ConnectionManager_t* cm  );

/* Called when we're finished */
tptp_int32 connectionManager_cleanup( ConnectionManager_t* cm );

/* Called by the transport layers when they have received a connection */
tptp_int32 connectionManager_addConnection( tptp_object* cmo, tptp_uint32 transportID, tptp_uint32* connectionID );

/* Called by the transport layers when they drop a connection */
tptp_int32 connectionManager_removeConnection( tptp_object* cmo, tptp_uint32 connectionID );

/* Called by the transport layers when they have received a data connection */
tptp_int32 connectionManager_addDataConnection( tptp_object* cmo, tptp_uint32 transportID, tptp_uint32 flags, tptp_uint32* connectionID );

/* Called by the transport layers when they have received a data connection */
tptp_int32 connectionManager_addDirectDataConnection( tptp_object* cmo, tptp_uint32 transportID, tptp_uint32 flags, tptp_uint32 descriptor, tptp_uint32* connectionID );


/* Called by the transport layers when they drop a data connection */
tptp_int32 connectionManager_removeDataConnection( tptp_object* cmo, tptp_uint32 connectionID );

/* Called by the command extractors when they have an incoming command */
tptp_int32 connectionManager_processCommand( tptp_object* cmo, tptp_uint32 size, const tptp_string* cmd );

/* Called by message pipeline components to log errors */
tptp_int32 connectionManager_logEvent( tptp_object* cmo, 
                                       tptp_string* subcomponent,
                                       tptp_uint32  instanceId,
                                       tptp_string* filename,
                                       tptp_int32   lineNum,
                                       tptp_int32   severity, 
                                       tptp_string* event );

/* Called by internal components to send/forward messages */
tptp_int32 connectionManager_sendMessage( ConnectionManager_t* cm, tptp_uint32 connectionID, const tptp_string* msg );

/* Called by the Agent Manager to bind data connections */
tptp_int32 connectionManager_bindDataConnections( ConnectionManager_t* cm, 
                                                  tptp_uint32          sourceID, 
                                                  tptp_uint32          context, 
                                                  tptp_uint32          dataConn1, 
                                                  tptp_uint32          dataConn2 );

/* Called by the Agent Manager to get the information to pass on to agents so the peer monitoring can be requested */
tptp_int32 connectionManager_getPeerConnectionInfo( ConnectionManager_t* cm, tptp_string* pmt, tptp_string* type, tptp_string** ci );

/* Called by the Agent Manager to establish a connection to pass on a peer monitoring request */
tptp_int32 connectionManager_connectToPeer( ConnectionManager_t* cm, tptp_string* rmi, tptp_uint32* connectionID );

/* Called by the Agent Manager to drop a connection */
tptp_int32 connectionManager_dropPeerConnection( ConnectionManager_t* cm, tptp_uint32 connectionID );

/* Called by the Configuration Manager to allow any necessary peer connection initialization to take place */
tptp_int32 connectionManager_initializePeerConnectionTransport( ConnectionManager_t* cm, char* peerConnectionTransport );

#endif /* __CONNECTIONMANAGER_H__ */
