/*******************************************************************************
 * Copyright (c) 2005, 2006 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Andy Kaylor, Intel - Initial re-implementation of Agent Controller
 * $Id: ConnectionManagerPrivate.h,v 1.12 2006/11/01 22:47:16 akaylor Exp $
 *******************************************************************************/ 

#ifndef __CONNECTION_MGR_PRIVATE_H__
#define __CONNECTION_MGR_PRIVATE_H__


#include "ConnectionManager.h"
#include "tptp/TPTPUtils.h"
#include "tptp/MsgPipeline.h"
#include "tptp/TPTPCommon.h"

typedef struct
{
	DLL_REFERENCE                  dllRef;
	tptp_uint32                    transportID;
	tptp_string*                   type;
	tptp_object                    tlo;
	createTransportListener_ptr_t  createTransportListener;
	destroyTransportListener_ptr_t destroyTransportListener;
	setProcessMessageFunc_ptr_t    setProcessMessageFunc;
	startTransportListener_ptr_t   startTransportListener;
	stopTransportListener_ptr_t	   stopTransportListener;
	terminateConnection_ptr_t      terminateConnection;
	sendMessage_ptr_t              sendMessage;
	sendData_ptr_t                 sendData;
	setIncomingDataFunc_ptr_t      setIncomingDataFunc;
	setDataDescriptor_ptr_t        setDataDescriptor;
	terminateDataConnection_ptr_t  terminateDataConnection;
	getPeerConnectionInfo_ptr_t    getPeerConnectionInfo;
	createPeerConnection_ptr_t     createPeerConnection;
	setPeerAttachInfo_ptr_t        setPeerAttachInfo;
} transport_layer_t;

typedef struct
{
	DLL_REFERENCE                  dllRef;
	tptp_object                    cxo;
	createCommandExtractor_ptr_t   createCommandExtractor;
	destroyCommandExtractor_ptr_t  destroyCommandExtractor;
	processMessage_ptr_t           processMessage;
} command_extractor_t;

typedef struct
{
	transport_layer_t    tl;
	command_extractor_t  cx;
} message_pipeline_t;

typedef struct
{
	tptp_uint32         connectionID;
	transport_layer_t*  transport;
} connection_t;

typedef struct
{
	tptp_uint32         connectionID;
	tptp_uint32         flags;
	tptp_uint32         bound;
	tptp_uint32			descriptor;
	transport_layer_t*  transport;
} data_connection_t;

tptp_int32 connectionManager_loadTransportLayer( ConnectionManager_t* cm, 
                                          const char*          libName, 
                                          const char*          configData, 
                                          transport_layer_t*   tl );
tptp_int32 connectionManager_loadCommandExtractor( ConnectionManager_t* cm, 
                                            const char*          libName, 
                                            command_extractor_t* cx );

transport_layer_t* connectionManager_findTransportLayer( ConnectionManager_t* cm, tptp_uint32 id );
connection_t* connectionManager_findConnection( ConnectionManager_t* cm, tptp_uint32 id );
data_connection_t* connectionManager_findDataConnection( ConnectionManager_t* cm, tptp_uint32 id );

void connectionManager_sendErrorResponse( ConnectionManager_t* cm, tptp_int32 errorCode, tptp_int32 sourceID, tptp_int32 contextID );
void connectionManager_logServiceEvent( ConnectionManager_t* cm, tptp_int32 severity, char* errorStr );

transport_layer_t* connectionManager_findTransportLayerByType( ConnectionManager_t* cm, tptp_string* rmt );


#endif /* __CONNECTION_MGR_PRIVATE_H__ */
