/*******************************************************************************
 * Copyright (c) 2005, 2008 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Andy Kaylor, Intel - Initial re-implementation of Agent Controller
 * 
 * $Id: LoggingService.h,v 1.10 2008/11/13 20:00:48 jkubasta Exp $
 *******************************************************************************/ 

#ifndef __LOGGINGSERVICE_H__
#define __LOGGINGSERVICE_H__

#include "ACTypes.h"
#include "tptp/TPTPTypes.h"
#include "tptp/TPTPLogUtils.h"
#include "tptp/TPTPUtils.h"
#include "tptp/TPTPCommon.h"

typedef struct
{
	tptp_filehandle    file;
	tptp_int32         loggingEnabled;
	tptp_int32         loggingLevel;
	tptp_loggingFormat loggingFormat;
	char               loggingDirectory[_MAX_PATH];     
} LoggingService_t;

tptp_int32 loggingService_init( LoggingService_t* ls );
tptp_int32 loggingService_cleanup( LoggingService_t* ls );
void       loggingService_disableLogging( LoggingService_t* ls );
tptp_int32 loggingService_setLogDirectory( LoggingService_t* ls, const tptp_string* dir );
tptp_int32 loggingService_setLoggingLevel( LoggingService_t* ls, tptp_int32 level );
tptp_int32 loggingService_setLoggingFormat( LoggingService_t* ls, tptp_loggingFormat format );
tptp_int32 loggingService_logEvent( LoggingService_t* ls, 
                                    tptp_string*      subcomponent,
                                    tptp_uint32       instanceId,
                                    tptp_string*      filename, 
                                    tptp_int32        lineNum, 
                                    tptp_int32        severity, 
                                    tptp_string*      event );
tptp_int32 loggingService_processCommand( LoggingService_t* ls, const char* cmd );


#endif /* __LOGGINGSERVICE_H__ */

#define AC_LOG_FILE_NAME "servicelog.log"
