/*******************************************************************************
 * Copyright (c) 2005 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu K Naikawadi,Intel - Initial API and implementation
 *
 * $Id: BaseCollectorImpl.cpp,v 1.11 2005/10/07 18:29:20 akaylor Exp $ 
 *******************************************************************************/ 


#include <iostream>

#include "tptp/agents/BaseCollectorImpl.h"
#include "tptp/agents/AgentLog.h"

using namespace std;


BaseCollectorImpl::BaseCollectorImpl(char* name) : BaseAgentImpl(name), EventProviderImpl(name), DataProviderImpl(name), VariableProvider(name)
{

	//TPTP_LOG_DEBUG_MSG(this, "BaseCollectorImpl(name) constructor called");
}


BaseCollectorImpl::~BaseCollectorImpl()
{
	//TPTP_LOG_DEBUG_MSG(this, "BaseCollectorImpl destructor called");
}


int BaseCollectorImpl::run(CmdBlock* cmd)
{
	TPTP_LOG_DEBUG_MSG(this, "BaseCollectorImpl::run() called");

	return 0;
}
 

int BaseCollectorImpl::pause(CmdBlock* cmd)
{
	TPTP_LOG_DEBUG_MSG(this, "BaseCollectorImpl::pause() called");

	return 0;
}

int BaseCollectorImpl::resume(CmdBlock* cmd)
{

	TPTP_LOG_DEBUG_MSG(this, "BaseCollectorImpl::resume() called");

	return 0;
}

int BaseCollectorImpl::cancel(CmdBlock* cmd)
{
	TPTP_LOG_DEBUG_MSG(this, "BaseCollectorImpl::cancel() called");

	return 0;

}
int BaseCollectorImpl::stop(CmdBlock* cmd)
{
	TPTP_LOG_DEBUG_MSG(this, "BaseCollectorImpl::stop() called");

	return 0;
}


int BaseCollectorImpl::snapshot(CmdBlock* cmd)
{

	TPTP_LOG_DEBUG_MSG(this, "BaseCollectorImpl::snapshot() called");

	return 0;
}


int BaseCollectorImpl::getData(CmdBlock* cmd)
{

	TPTP_LOG_DEBUG_MSG(this, "BaseCollectorImpl::getData() called");

	return 0;
}


int BaseCollectorImpl::getState(CmdBlock* cmd)
{

	TPTP_LOG_DEBUG_MSG(this, "BaseCollectorImpl::getAgentState() called");

	return this->agentState;
}



int BaseCollectorImpl::processCommand(CmdBlock* cmdBlock)
{

	int  ret = -1;

	ret = BaseAgentImpl::processCommand(cmdBlock);


	if (ret == 0) return ret;

	TPTP_LOG_DEBUG_MSG(this, "BaseCollectorImpl::processCommand called");

	char* cmdName = cmdBlock->getCommandName();

	if ( isEqualString( cmdBlock->getIID(), "org.eclipse.tptp.Collector"))
	{

		if (isEqualString(cmdName, "stop"))
		{
			this->stop(cmdBlock);
			ret = 0;
		}
		else if (isEqualString(cmdName, "run"))
		{
			TPTP_LOG_DEBUG_MSG(this, "Calling run");
			this->run(cmdBlock);
			ret = 0;
		}
		else if (isEqualString(cmdName, "pause"))
		{
			this->pause(cmdBlock);
			ret = 0;
		}
		else if (isEqualString(cmdName, "resume"))
		{
			this->resume(cmdBlock);
			ret = 0;
		}
		else if (isEqualString(cmdName, "cancel"))
		{
			this->cancel(cmdBlock);
			ret = 0;
		}
		else if (isEqualString(cmdName, "getData"))
		{
			this->getData(cmdBlock);
			ret = 0;
		}
		else if (isEqualString(cmdName, "getState"))
		{
			this->getState(cmdBlock);
			ret = 0;
		}
	}
	else if ( isEqualString( cmdBlock->getIID(), "org.eclipse.tptp.dataProvider") ||
		      (isEqualString( cmdBlock->getIID(), "org.eclipse.tptp.agentManager") && 
			   isEqualString( cmdBlock->getCommandName(), "dataConnectionsBound")) )
	{
		ret = processDataProviderCommands(cmdBlock);

	}

	else if (isEqualString( cmdBlock->getIID(), "org.eclipse.tptp.eventProvider"))
	{
		ret = processEventProviderCommands(cmdBlock);		
	}
	else if (isEqualString( cmdBlock->getIID(), "org.eclipse.tptp.variableProvider"))
	{
		ret = processVariableProviderCommands(cmdBlock);		
	}

	return ret;
}

