/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AbstractHeapSnapshotManager.cpp,v 1.2 2007/04/06 00:16:03 jkubasta Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

#include "AbstractHeapSnapshotManager.h"


#ifdef IBM_OE
#pragma convlit(suspend)
#endif //IBM_OE

#ifdef IBM_OE
#pragma convlit(resume)
#endif //IBM_OE


AbstractHeapSnapshotManager::AbstractHeapSnapshotManager(SnapshotFiller*         filler,
							 SnapshotAgentInterface* agent,
							 JVMPI_Interface*        jvmpi)
{
  _filler = filler;
  _agent  = agent;
  _jvmpi  = jvmpi;
}
SnapshotFiller& AbstractHeapSnapshotManager::filler() const
{
  return *_filler;
}
SnapshotAgentInterface& AbstractHeapSnapshotManager::agent() const
{
  return *_agent;
}
JVMPI_Interface& AbstractHeapSnapshotManager::jvmpi() const
{
  return *_jvmpi;
}
