/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AbstractHeapSnapshotManager.h,v 1.2 2007/04/06 00:18:17 jkubasta Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

#ifndef ABSTRACT_HEAP_SNAPSHOT_MANAGER_H
#define ABSTRACT_HEAP_SNAPSHOT_MANAGER_H

#include <jvmpi.h>
#include "HeapSnapshotManager.h"
#include "SnapshotAgentInterface.h"
#include "SnapshotFiller.h"

class AbstractHeapSnapshotManager : public HeapSnapshotManager {
 public:
  AbstractHeapSnapshotManager(SnapshotFiller* filler, SnapshotAgentInterface* agent, JVMPI_Interface* jvmpi);
 protected:
   SnapshotFiller& filler() const;
   SnapshotAgentInterface& agent() const;
   JVMPI_Interface& jvmpi() const;

 private:
   SnapshotFiller*         _filler;
   SnapshotAgentInterface* _agent;
   JVMPI_Interface*        _jvmpi;
};

#endif /* ABSTRACT_HEAP_SNAPSHOT_MANAGER_H */
