/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: HeapSnapshotManager.h,v 1.2 2007/04/06 00:19:11 jkubasta Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

#ifndef HEAP_SNAPSHOT_MANAGER_H
#define HEAP_SNAPSHOT_MANAGER_H

#include <jvmpi.h>

typedef enum HeapDumpMode {
  notAsking,
  askingForDumpPopulation,
  askingForDumpReferences,
  askingForMarkGeneration
} HeapDumpMode;

class HeapSnapshotManager {
 public:
  virtual char isStateless() const = 0;
  virtual void handleHeapSnapshot(JNIEnv*      env,
				  int          dump_level,
				  char*        begin,
				  char*        end,
				  HeapDumpMode heapDumpMode) = 0;
};

#endif /* HEAP_SNAPSHOT_MANAGER_H */
