/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SnapshotAgentInterface.h,v 1.2 2007/04/06 00:20:57 jkubasta Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

#ifndef SNAPSHOT_AGENT_INTERFACE_H
#define SNAPSHOT_AGENT_INTERFACE_H

class SnapshotAgentInterface {
 public:
  virtual char getClassInfo(jobjectID classID,
			    char**    className_outvar,
			    char*     className_freeMe,
			    int*      numInterfaces_outvar,
			    int*      numStaticReferenceFields_outvar) = 0;
#ifdef __OS400__
  virtual char getOS400ClassInfo(jobjectID classID,
			    char**    className_outvar,
			    char*     className_freeMe,
			    int*      numInterfaces_outvar,
			    int*      numStaticReferenceFields_outvar,
			    unsigned int * object_dump_len,
			    char** object_dump_data) = 0;
#endif
  virtual char stillAlive() = 0;
  virtual char stillTracing() = 0;
  virtual char shouldIReportHeapSnapshotDuration() = 0;
  virtual short swap16(short n) = 0;
  virtual int swap32(int n) = 0;
  virtual char dump_read_u1(char* cursor) = 0;
  virtual short dump_read_u2(char* cursor) = 0;
  virtual int dump_read_u4(char* cursor) = 0;
  virtual jobjectID dump_read_jobjectID(char* cursor) = 0;

  virtual void status(const char* message) = 0;
  virtual void status(const char* message, int message2) = 0;
  virtual void error(const char* message) = 0;
};

#endif /* SNAPSHOT_AGENT_INTERFACE_H */
