/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SnapshotFiller.h,v 1.2 2007/04/06 00:21:57 jkubasta Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

#ifndef SNAPSHOT_FILLER_H
#define SNAPSHOT_FILLER_H

#include <jvmpi.h>

class SnapshotFiller {
 public:
  virtual void FillClassInfo(jobjectID   cls,
			     const char* className,
			     int         numStaticReferenceFields,
			     int         numInterfaces,
#ifdef __OS400__
				 int         instanceSize,
				 jobjectID*  classRefs) = 0;
#else
				 int         instanceSize) = 0;
#endif

  virtual void FillJvmpiSnapshot(char* begin, char* end) = 0;
};

#endif /* SNAPSHOT_FILLER_H */
