/**********************************************************************
 * Copyright (c) 2005, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: StatelessHeapSnapshotManager.h,v 1.3 2009/08/26 14:59:51 jwest Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

#ifndef STATELESS_HEAP_SNAPSHOT_MANAGER_H
#define STATELESS_HEAP_SNAPSHOT_MANAGER_H

#include "AbstractHeapSnapshotManager.h"




class StatelessHeapSnapshotManager : public AbstractHeapSnapshotManager {
 public:
  StatelessHeapSnapshotManager(SnapshotFiller*         filler,
			       SnapshotAgentInterface* agent,
			       JVMPI_Interface*        jvmpi,
			       bool					   optHeapDebug,
			       FILE *				   debugOut);

  void handleHeapSnapshot(JNIEnv*      env,
			  int          dump_level,
			  char*        begin,
			  char*        end,
			  HeapDumpMode heapDumpMode);
  char isStateless() const;

 protected:
  void *prof_dump_read_ptr(char **current) const;
  char getClassInfos(char* begin, char* end) const;
  void parseClassDump(unsigned int object_dump_len, 
  	char *object_dump_data, int numInterfaces, 
  	int numStaticReferenceFields,
	unsigned int *instanceSize, jobjectID** classRefs) const;

 private:
   bool				_optHeapDebug;
   FILE*			_debugOut;
};

#endif /* STATELESS_HEAP_SNAPSHOT_MANAGER_H */
