/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: JvmpiWriter.h,v 1.2 2007/04/06 00:29:42 jkubasta Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

#ifndef __JVMPIWRITER__
 #define __JVMPIWRITER__


/* This macro defines the XML4Profiling Specification level of the agent */
#define AGENT_VERSION "1.000"

#ifdef _WIN32
	#include <winsock2.h> /* Bug 134924 */
	#include <windows.h>
#else
	#include <pthread.h>
#endif

#include <stdio.h>
#include <string.h>
#include <jvmpi.h>
#include "filters.h"

#include "hash.h"
#include "stack.h"
#include "lock3.h"
#include "performance.h"    /* 183945 - changed uppercase p to lowercase */

#ifndef TRUE
 #ifdef _HPUX
  #define TRUE TRUE
 #else
  #define TRUE 1
 #endif
#endif

#ifndef FALSE
 #ifdef _HPUX
  #define FALSE FALSE
 #else
  #define FALSE 0
 #endif
#endif


enum ThrowOrCatch {Throw, Catch};

/* RKD:  Request event macro as this has a slightly different signature on OS/400 but this
         will be changing in the near future.
*/
#ifdef __OS400__
 #define REQUEST_EVENT(A, B) _jvmpiAgent_jvmpiInterface->RequestEvent(A, (void*)(B));
 #define REQUEST_EVENT2(A, B) _jvmpiAgent_jvmpiInterface->RequestEvent2(A, B); /* 232010 */
#else
 #define REQUEST_EVENT(A, B) _jvmpiAgent_jvmpiInterface->RequestEvent(A, B);
 #define REQUEST_EVENT2(A, B) _jvmpiAgent_jvmpiInterface->RequestEvent(A, B); /* 232010 */
#endif

/* 236501 - STRDUP now defined in RAComm.h
#ifdef __OS400__
  #define strdup(a) a
#endif
*/

typedef struct
{
 unsigned long traceMask;
} EventList;

typedef struct {
	unsigned long index;
	timestamp_t lastGenerationTime;
}GenerationInfo_t;

/* Bug 64476 Moved the #if defined above the typedef */
#if defined __cplusplus
 extern "C" {
#endif

/* Piyush Agarwal */
typedef void (*optHeapDumpFileInfoCallBackType)(char *filename);
typedef struct {
    optHeapDumpFileInfoCallBackType ohdcb ;
} OptHeapCallBack ;


enum JavaVendor {VendorIBM, VendorSun, VendorHP, VendorOther}; 
enum JavaVersion {Version13,Version140,Version141,Version142,VersionOther}; 

extern enum JavaVendor _javaVendor; 
extern enum JavaVersion _javaVersion; 

/* GLOBALS
 */
extern JVMPI_Interface * _jvmpiAgent_jvmpiInterface; /* JVMPI Interface pointer created in JVM_OnLoad */
extern jmethodID _jvmpiAgent_setExceptionTracing;
extern jclass _jvmpiAgent_JVMPIException;
extern JavaVM * _jvmpiAgent_jvm;            /* JVM Pointer passed in on JVM_OnLoad */
extern Lock_t _jvmpiAgent_synchLock;
extern char *_jvmpiAgent_trace_id;
extern const char *_jvmpiAgent_nodeUUID;
extern const char *_jvmpiAgent_processUUID;
extern GenerationInfo_t _heapDumpInfo;
extern RA_AGENT_HANDLE _jvmpiAgent_bindingStorage;	/* The Agent handle for the RAC */

extern SegmentedValue_t _jvmpiAgent_collation;

/* Call Back Functions */
extern OptHeapCallBack  _jvmpiAgent_optHeapCallBack ;

/* Function pointer definition for the JVM interface function that converts JNI
 object handles to JVMPI object identifiers.  This API is available as follows:
 Sun JDK 1.2.2 Classic as an undocumented entry point in the JVM
 Sun JDK 1.3 Classic as an undocumented entry point in the JVM
 Note: The Sun JDK 1.3 Hotspot JVM documents this API as part of the JVMPI
 interface, however they do not include the definition of this API in the JVMPI
 header file that they ship.  In addition, they have removed the entry point for
 this function from the Hotspot JVM. So at this time, this function is not
 available when running under the Sun Hotspot JVM.
 IBM JDK 1.2.2 as both an entry point in the JVM and as part of the JVMPI interface
 functions.
 IBM JDK 1.3 as both an entry point in the JVM and as part of the JVMPI interface
 functions.
*/
typedef jobjectID (*Jobject2jobjectID)(jobject obj);



extern void jvmpiAgent_outputMethodDeclaration(HashEntry *methodHashEntry, ThreadPrivateStorage *tps);
extern void jvmpiAgent_outputClassDeclaration(HashEntry *classHashEntry, ThreadPrivateStorage *tps);

extern void sendErrorMessage(RA_ERROR_LEVEL severity,
							 const char *errorId,
							 const char *errorString);

/** GET_THREAD_LOCAL_STORAGE  *************************************************
  * This function returns the address of the thread local storage for the
  * specified JNIEnv (aka thread).  A special thread local storage structure is
  * allocated for static references and is returned when the JNIEnv parameter is
  * 0 or if the JVM is in Garbage Collection or Shutdown mode. Garbage Collection
  * and Shutdown mode must be handled in this way because some versions of the
  * JVM use special threads to do this processing which cause the
  * GetThreadLocalStorage interface function to trap.
  */
extern ThreadPrivateStorage *jvmpiAgent_getThreadLocalStorage(JNIEnv *env_id);


#if defined __cplusplus
 }
#endif
#endif
