/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: StatelessHeapSnapshotManager_C.h,v 1.2 2007/04/06 00:31:52 jkubasta Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

#ifndef STATELESS_HEAP_SNAPSHOT_MANAGER_C_H
#define STATELESS_HEAP_SNAPSHOT_MANAGER_C_H

#include <jvmpi.h>

/* Error Codes */ 
#define RA_OPT_HEAP_DISK_FULL             1
#define RA_OPT_HEAP_COULD_NOT_CREATE_FILE 2

#ifdef __cplusplus
extern "C"
#endif
int StatelessHeapSnapshotManager_handleHeapSnapshot_FromC(JNIEnv*      env,
							   int          dump_level,
							   char*        begin,
							   char*        end);

#ifdef __cplusplus
extern "C"
#endif
void StatelessHeapSnapshotManager_setup_FromC(JVMPI_Interface *jvmpi,
											  BOOL classInfoCallback);

#ifdef __cplusplus
extern "C"
#endif
void StatelessHeapSnapshotManager_classInfoCallback(const char*  className,
						    int          numInterfaces,
						    int          numStaticFields,
						    JVMPI_Field* statics);

#ifdef __OS400__
#ifdef __cplusplus
extern "C"
#endif
void StatelessHeapSnapshotManager_objectDumpCallbackMethod(JVMPI_Event *event);
#endif
/* Bug 64476 */
#ifdef __cplusplus
extern "C"
#endif
void StatelessHeapSnapshotManager_optHeapCallBack(char* filename)  ;

#endif /* STATELESS_HEAP_SNAPSHOT_MANAGER_C_H */
