/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: binary_print.h,v 1.2 2007/04/06 00:36:16 jkubasta Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

#ifndef BINARY_PRINT_H
#define BINARY_PRINT_H

extern void BINARYTRACE_printUnknownRoot(ThreadLocalStorage* tps,
				    ObjectEntry*        unknown);
extern void BINARYTRACE_printJNIGlobalRoot(ThreadLocalStorage* tps,
				      ObjectEntry*        parent,
				      ObjectEntry*        child);
extern void BINARYTRACE_printJNILocalRoot(ThreadLocalStorage* tps,
				     ObjectEntry*        object,
				     ThreadLocalStorage* localToThisThread,
				     int stackDepth);
extern void BINARYTRACE_printJavaStackRoot(ThreadLocalStorage* tps,
				      ThreadLocalStorage* rootedToThisThread,
				      ObjectEntry*        object,
				      int                 depth);
extern void BINARYTRACE_printNativeStackRoot(ThreadLocalStorage* tps,
					ThreadLocalStorage* rootedToThisThread,
					ObjectEntry*        object);
extern void BINARYTRACE_printStickyClassRoot(ThreadLocalStorage* tps,
					ObjectEntry*        clazzObject);
extern void BINARYTRACE_printThreadRoot(ThreadLocalStorage* tps,
				   ThreadLocalStorage* theThread,
				   ObjectEntry*        theThreadObject);
extern void BINARYTRACE_printMonitorRoot(ThreadLocalStorage* tps,
				    ObjectEntry*        monitorObject);

extern void BINARYTRACE_printGeneration(ThreadLocalStorage* tps);
extern unsigned short BINARYTRACE_printArrayReference(char* buffer,
						 unsigned long parentOID,
						 unsigned long childOID);
unsigned short BINARYTRACE_printClassReference(char* buffer,
					  unsigned long parentCID,
					  unsigned long childOID);
extern unsigned short BINARYTRACE_printObjectReference(char* buffer,
						  unsigned long parentOID,
						  unsigned long childOID);
extern void BINARYTRACE_printBOB(ThreadLocalStorage* tps);
extern void BINARYTRACE_printEOB(ThreadLocalStorage* tps);
extern void BINARYTRACE_printFields(ThreadLocalStorage* tps,
			       ClassEntry* classEntry,
			       jint        numFields,
			       int         startIndex,
			       PI_Field*   fields,
			       BOOL        isStatic);
extern unsigned short BINARYTRACE_printClassDefine(char*       buffer,
					      ClassEntry* classEntry);
extern unsigned short BINARYTRACE_printClassLoad(char*       buffer,
					    ClassEntry* classEntry);
extern unsigned short BINARYTRACE_printMethodDefine(char*        buffer,
					       MethodEntry* methodEntry);
extern unsigned short BINARYTRACE_printMethodEnter(char*          buffer,
					      StackEntry*    stackEntry);
unsigned short BINARYTRACE_printMethodExit(char*               buffer,
				      ThreadLocalStorage* tps,
				      timestamp_t timeJustAfterGotControl);
extern unsigned short BINARYTRACE_appendTimestamp(char*           buffer,
					     unsigned short  offset,
					     timestamp_t*    time);

extern unsigned short BINARYTRACE_printThreadStart(char*               buffer,
					      ThreadLocalStorage* tps);
extern unsigned short BINARYTRACE_printObjectFree(char*      buffer,
					     HashEntry* objectHashEntry);
extern unsigned short
BINARYTRACE_printWitnessedObjectAllocation(char*                 buffer,
				      ThreadPrivateStorage* creatingThread,
				      HashEntry*            objectHashEntry,
				      HashEntry*            classHashEntry,
				      timestamp_t           allocTime);
extern unsigned short BINARYTRACE_printObjectAllocation(char*      buffer,
						   HashEntry* objectHashEntry,
						   HashEntry* classHashEntry);
extern unsigned short BINARYTRACE_printClassUnload(char* buffer,
					      HashEntry* classHashEntry);
extern unsigned short BINARYTRACE_printThreadEnd(char*               buffer,
					    ThreadLocalStorage* tps);
extern unsigned short BINARYTRACE_printGcStart(char* buffer);
extern unsigned short BINARYTRACE_printGcFinish(char* buffer);
extern unsigned short BINARYTRACE_printEndOfXMLHeader(char* buffer);
extern void BINARYTRACE_printTraceHeader(ThreadLocalStorage* tps);
extern void BINARYTRACE_printTraceEnd(ThreadLocalStorage* tps);

/* #include "watson_fieldvalues.h" */

#endif /* BINARY_PRINT_H */
