/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: filters.h,v 1.2 2007/04/06 00:39:52 jkubasta Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

#ifndef __FILTERS_H__
 #define __FILTERS_H__ 1


#define FILTER_LIST_INCREMENT 100
#define TRIGGER_LIST_INCREMENT 100
#define MAX_METHOD_FILTERS_PER_CLASS 5

enum FilterMode {EXCLUDE = 0, INCLUDE = 1};
enum GenericPattern {NONE, PREFIX, SUFFIX};

extern char	 _setPathDelimiter;


typedef struct {
	enum FilterMode mode;
	enum GenericPattern genericPattern;
	unsigned int patternLength;
	char * pattern;
}MethodFilter_t;

typedef struct {
	enum GenericPattern genericPattern;
	unsigned int methodDetailCount;
	MethodFilter_t methodDetails[MAX_METHOD_FILTERS_PER_CLASS];  /* Initial limit of specific methods per class */
	unsigned int patternLength;
	char * pattern;
}Filter;


typedef struct {
  unsigned int methodnameLength;
  char *methodname;
  unsigned int classnameLength;
  char *classname;
  int count;
}Trigger;

/* 174190 commented out because not necessary - not used in any other file
extern Filter *_jvmpiAgent_Filters;
*/
/*
 This function is used in standalone mode to read and parse a file containing a set of filter
 definitions.  It uses the jvmpiAgent_AddFilter and jvmpiAgent_ApplyFilters functions to
 actually set the active filter definitions for the agent.
*/
int jvmpiAgent_processFilters(char * fileName);

/** jvmpiAgent_checkMethodFilters *****************************************************************
  * This function determines whether a method is to be INCLUDED or EXCLUDED.  This can occur if
  * the class filter has a matching method filter, or if the class filter itself is NULL, i.e.,
  * the class does not match any existing filter.
  *
  * @param mthd_name    the method name to match
  * @param cls_fltr     the matching filter for this class
  * @returns    INCLUDE or EXCLUDE as is appropriate.
  */
int jvmpiAgent_checkMethodFilters(char *mthd_name, Filter *cls_fltr);

/** jvmpiAgent_getFilter **************************************************************************
  * This function returns the first class filtering that matches the class and method names.
  *
  * @param cls_name     the class name to match
  * @param mthd_name    the method name to match
  * @returns    the first matching class filter, or NULL if none is found.
  */
Filter *jvmpiAgent_getFilter(char *cls_name, char *mthd_name);

/*
 This function outputs the currently active filter definitions as elements in the trace.
*/
void jvmpiAgent_printFilters();

/*
 This function is takes the filter definitions accumulated using the jvmpiAgent_AddFilter function,
 and replaces the current set of active filter definitions.  In addition, the accumlated filter definitions
 are cleared.
 Note: It is recommended that the JVM be suspended during the execution of this function in order
 to avoid accessing the filter definitions while they are in an indeterminate state.
*/
void jvmpiAgent_applyFilters();

/** jvmpiAgent_addFilter **************************************************************************
  * This function appends a new filter using the class and method patterns with the filtering
  * mode.  The filters are saved in an ordered list, and the order in which they are inserted
  * makes a difference.  The filters will not be used until they are applied by calling
  * jvmpiAgent_ApplyFilters().  NULL, empty strings, and '*'s are all treated as wildcard
  * characters.
  *
  * @param cls_ptrn     the pattern to match a class
  * @param mthd_ptrn    the method pattern to match
  * @param mode         whether the method will be INCLUDED or EXCLUDED
  */
void jvmpiAgent_addFilter(char *classPattern, char *methodPattern, enum FilterMode mode);

/** jvmpiAgent_getClassFilterMode *****************************************************************
  * This function determines whether a class is to be INCLUDED or EXCLUDED.  This can occur if
  * the class filter has a wildcard method filter, or if the class filter itself is NULL, i.e.,
  * the class does not match any existing filter.
  *
  * @param cls_fltr the matching filter for this class
  * @returns    INCLUDE or EXCLUDE as is appropriate.
  */
enum FilterMode jvmpiAgent_getClassFilterMode(Filter *cls_fltr);

/* Initialize the Filter data structures */
void jvmpiAgent_initializeFilters(char pathChar);

void jvmpiAgent_initializeTriggers(char pathChar);

void jvmpiAgent_changeDelimiter(void);

int jvmpiAgent_processTriggers(char *filename);

int jvmpiAgent_checkTrigger(char *className, char *methodName);

int jvmpiAgent_addTrigger(char *methodname, char *classname, int count);

void jvmpiAgent_applyTriggers();

#endif
