 /**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: options.h,v 1.2 2007/04/06 00:44:08 jkubasta Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


#ifndef __OPTIONS_H__
#define __OPTIONS_H__ 1

#if defined __cplusplus
 extern "C" {
#endif

/* DNS - added following include */
#include "RADataTransfer.h"

enum IdStyle {IdStyleStatic, IdStyleRelocatable, IdStyleStaticAndRelocatable};

enum ObjRefMode {RespectFilter, Filter4Owner, IgnoreFilter};

enum Gc {GcNone, GcDeletes, GcMoves, GcDeletesAndMoves};

enum StackInfo {StackInfoNone, StackInfoNormal, StackInfoContiguous, StackInfoBoundary, StackInfoBoundaryAndContiguous};

enum CompressLevel {CompressNone, CompressAggregate};

/*
HeapInfo is depreciated. Hoever, existing clients will keep working:
    HeapInfoNone == TraceModeNoObjectCorrelation, and
    HeapInfoAll == TraceModeFull
enum HeapInfo {HeapInfoNone, HeapInfoAll };
*/

/* 57681 don't add new tags at the beginning: leave it TraceModeFull.
 * Otherwise you'll change the agent's behavior 
 * when _jvmpiagent_Options.mode is never set, which is common.
 */
enum TraceMode {TraceModeFull, TraceModeNoObjectCorrelation, TraceModeStackSampling, TraceHeap, TraceOptimizedHeap, TraceModeNone };

enum TraceStartMode {TraceStartModeFilter, TraceStartModeTriggerSingleThreaded, TraceStartModeTriggerMultiThreaded};

enum BurstMode {BurstModeNone, BurstModeSeconds, BurstModeInvocations, BurstModeSecondsAndInvocations};

enum MonitorMode {MonitorNone, MonitorAll}; 

/* 60879 a structure used for storing options that the piAgent otherwise doesn't care about. 
  This is used mainly so that we can echo back these options to the UI. */ 

typedef struct gen_option {
	char *key; 
	char *value;
	struct gen_option *next;  
} generic_option; 

/** These are the global options specified on the command line and/or profile of the agent at
    invocation time.
  */
typedef struct {
 unsigned int unreferencedSymbols:1;		/* Print unreferenced symbols? (FALSE) */
 unsigned int timestamp:1;					/* Provide timestamps on all events (TRUE) */
 unsigned int debugHash:1;					/* Debug the hash table (FALSE) */
 unsigned int standalone:1;				    /* Standalone mode  (FALSE) */
 unsigned int application:1;				/* Application mode (FALSE) */
 unsigned int enabled:1;					/* Enabled mode  ie. attachable (TRUE)  */
 unsigned int traceExceptions:1;			/* Trace Exceptions  (FALSE) */
 unsigned int enableExceptionTracing:1;	    /* Place hooks for exception tracing (TRUE) */
 unsigned int enableLineCoverage:1;	        /* Place hooks for Line Coverage (TRUE) */
 unsigned int collationValues:1;            /* Print collation_value attribute on each element  */
 unsigned int filters:1;                    /* Print FILTER Elements (TRUE) */
 unsigned int options:1;                    /* Print OPTIONS Elements (TRUE) */
 unsigned int traceIdrefs:1;                /* Print trace_idref attribute on each element  */
 unsigned int gcDefault:1;                  /* GC default option */
 unsigned int methodCounts:1;               /* METHOD_COUNTS option  */
 unsigned int classLoadDetails:1;           /* CLASS_LOAD_DETAILS options */
 unsigned int methodDetails:1;				/* Provied a detailed descriptive about the methods (FALSE) */
 unsigned int objAllocIsArray:1;            /* OBJ_ALLOC_IS_ARRAY attribute option (TRUE) */
 unsigned int contextFlow:1;                /* CONTEXT_FLOW attribute option */
 unsigned int ticket:1;                     /* TICKET (TRUE) */
 unsigned int modeSet:1;					/* Was "mode" set on command line? */
 unsigned int exceptionTracingSet:1;		/* Was "exceptionTracing" set on the command line? */
 unsigned int lineCoverageSet:1;			/* Was "lineCoverage" set on the command line? */
 unsigned int gcSet:1;						/* Was "trackGCEvent" set on the command line? */
 unsigned int heapInfoCountSet:1;			/* Was "optHeapCount" set on the command line */
 unsigned int heapInfoFilePrefixSet:1;		/* Was "optHeapFilePrefix" set on the command line */
 unsigned int jinsightFormat:1;				/* I/O is in Jinsight format (FALSE)*/
 unsigned int cpuTime:1;					/* Are we emmiting thread cpuTime (FALSE) */
 unsigned int llDataEnabled:1;				/* Are we possibly emmiting line level data (FALSE) */
 enum IdStyle idStyle;
 enum ObjRefMode objRefMode;				/* RespectFilter, Filter4Owner, IgnoreFilter*/
 enum Gc gc;
 enum StackInfo stackInfo;					/* Stack maintenance mode  (StackInfoContiguous)*/
 enum CompressLevel compressLevel;          /* Compression level (CompressNone): controls pre-aggregate * 140009 */ 
 /* Depreciated: enum HeapInfo heapInfo; */	/* Object maintenence mode (HeapInfoAll) */
 enum TraceMode mode;						/* Mode to trace in (TraceModeFull) */
 enum TraceStartMode startMode;				/* When to start emiting trace info (TraceStartModeFilter) */
 enum BurstMode burstMode;					/* Whether we are tring in burst mode (BurstModeNone) */
 enum MonitorMode monitorMode;              /* Whether monitor events are being tracked */ 
 unsigned short burstInvocations;			/* The number of invocations to trace per monitoring session */
 unsigned short burstSeconds;				/* The number of seconds to trace per monitoring session */
 unsigned short boundaryDepth;				/* The depth to trace into filtered code */
 int heapInfoCount;							/* Number of heaps in each cycle, in TraceHeap and TraceOptimizedHeap modes (Default: 2) */
 ra_data_target_hdl_t targetHdl;
 char *invocationOptions;					/* The invocation options from the command line */
 char *filterFileName;						/* Name of the filters file (filters.txt)*/
 char *triggerFileName;						/* Name of the triggers file (triggers.txt)*/
 char *processName;							/* Name of the process */
 char *processType;							/* The type of process */
 char *outputFileName;						/* Output file for trace */
 char *heapInfoFilePrefix;					/* Filename prefix of the output trace in TraceHeap and TraceHeapOptimized modes (Default: heapinfo) */
 char *profileFile;							/* Name of the profile file */
 char *workDir;								/* Working directory (default is .) */
 char *extensionLibrary;					/* The Agent Extension library name to load (empty string means none) */
 generic_option *unknowns;					/* space to store the options the piAgent doesn't care about, but can echo back to the UI */ 
 unsigned int methodCountsOnly:1;			/* METHOD_COUNTS_ONLY indicates if we want to track _ONLY_ method counts (without methodEntry/exit events) */ 
} Options;

/* The structure to hold the invocation options for this process */
extern Options _jvmpiAgent_Options;

/** PROCESS_INVOCATION_OPTIONS *******************************************
  * Takes the command line parameters and populates the _jvmpiAgent_Options
  * with the correct values based upon the options specified.
  * @param   optionString - the command line args
  * @returns
  */
int jvmpiAgent_ProcessInvocationOptions(char *optionString);

/** PROCESS_PROFILE  ******************************************************
  * Process the specified profile and set the profile options within the
  * agent.
  * @param    profileName - the name of the profile file.
  * @returns
  */
int jvmpiAgent_processProfile(char *profileName);

/** SET_PROFILE_OPTION ****************************************************
  * Sets the profile option specified by key to the value specified by
  * value.
  * @param     key - the option that will be set
  * @param   value - the value that will be associated with the key.
  * @returns
  */
int jvmpiAgent_SetProfileOption(char * key, char * value);

/** CHECK_OPTIONS_CONSISTENCY ********************************************
  * Checks whether there is any conflict or inconsistency among various
  * options.
  * @returns -1 if error, 0 if no error
  */
int jvmpiAgent_CheckOptionsConsistency();

/** PRINT_OPTIONS ********************************************************
  * Prints the options
  */
void jvmpiAgent_printOptions();
unsigned int jvmpiAgent_isPrintObjId();
unsigned int jvmpiAgent_isPrintStaticId();
unsigned int jvmpiAgent_isPrintMethodId();
void printUsage();

/* initializeJvmpiAgentOptionsDefaults() - must be called at start up time */ 
void initializeJvmpiAgentOptionsDefaults();

unsigned int jvmpiAgent_isTracingHeap();

/* Piyush Agarwal */
/* If the piAgent is running in a controlled mode */
unsigned int jvmpiAgent_isControlled();

#if defined __cplusplus
 }
#endif

#endif
