/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: segmentedValue.c,v 1.2 2007/04/06 00:52:01 jkubasta Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

#include <stdlib.h>
#include <string.h>
#include "segmentedValue.h"
#include "utility.h"

void jvmpiAgent_initializeSegmentedValue(SegmentedValue_t *segValue, int freeFlag)
{
#ifdef SEGMENTED_VALUE_MULTIWORD
 segValue->numberOfWords = 1;
 if (freeFlag)
 {
  free(segValue->values);
 }
 segValue->values = (unsigned long *)jvmpiAgent_Calloc(segValue->numberOfWords * sizeof(unsigned long));
 segValue->values[0] = 0;
#else
 segValue->value=0;
#endif
}

SegmentedValue_t * jvmpiAgent_copySegmentedValue(SegmentedValue_t *target, SegmentedValue_t *source)
{
#ifdef SEGMENTED_VALUE_MULTIWORD
 int size = source->numberOfWords * sizeof(unsigned long);
 *target = *source;
 target->values = (unsigned long *)jvmpiAgent_Calloc(size);
 memcpy(target->values, source->values, size);
#else
  *target = *source;
#endif
 return target;
}

void jvmpiAgent_incrementSegmentedValue(SegmentedValue_t *segValue, unsigned long count)
{
#ifdef SEGMENTED_VALUE_MULTIWORD
 if (segValue->values[count] == 0xFFFFFFFF) {
   /* Going to wrap the current value */
   if (count+1 == segValue->numberOfWords)
   {
	/* Need to increase the number of words in the collation values list */
	unsigned long *p = segValue->values;
	segValue->numberOfWords++;
	segValue->values = (unsigned long *)jvmpiAgent_Calloc(segValue->numberOfWords * sizeof(unsigned long));
	memcpy(segValue->values, p, (segValue->numberOfWords-1) * sizeof(unsigned long));
	free(p);
   }
   jvmpiAgent_incrementSegmentedValue(segValue, count+1);
 }
 segValue->values[count]++;
#else
 segValue->value++;
#endif
}
