/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: segmentedValue.h,v 1.2 2007/04/06 00:52:56 jkubasta Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

#ifndef __SEGMENTEDVALUE_H__
#define __SEGMENTEDVALUE_H__ 1


#if defined __cplusplus
 extern "C" {
#endif
/******************************
 * SegmentedValue types and methods
 ******************************/

/* RKD:  The segmented values were initially designed to be a multiworded value.  This turned out to
         be a severe bottleneck due to memory fragmentation so it was disabled.  Defining
		 SEGMENTED_VALUE_MULTIWORD will re-enable this function.
*/
#ifdef SEGMENTED_VALUE_MULTIWORD
typedef struct {
 unsigned long numberOfWords;
 unsigned long *values;
} SegmentedValue_t;
#else
typedef struct {
 unsigned long value;
} SegmentedValue_t;
#endif

void jvmpiAgent_incrementSegmentedValue(SegmentedValue_t *segValue,
										unsigned long count);

SegmentedValue_t * jvmpiAgent_copySegmentedValue(SegmentedValue_t *target,
												 SegmentedValue_t *source);

void jvmpiAgent_initializeSegmentedValue(SegmentedValue_t *segValue,
										 int freeFlag);

#if defined __cplusplus
 }
#endif

#endif
