/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: strings.h,v 1.2 2007/04/06 00:56:20 jkubasta Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

#ifndef _STRINGS_H_
#define _STRINGS_H_

/** This is a list of all the hardcoded strings that are used during IO
    operations on the agent and the length of each string.  This is used
	to streamline IO operations
  */
#define UNAVAILABLE								"-Unavailable-"
#define STRLEN_UNAVAILABLE						11

/* XML Elements */

#define METHOD_EXIT_ELEMENT						"methodExit"
#define STRLEN_METHOD_EXIT_ELEMENT				10
#define METHOD_RETURN_ELEMENT					"methodReturn"
#define STRLEN_METHOD_RETURN_ELEMENT			12
#define JVM_SHUT_DOWN_ELEMENT					"runtimeShutdown"
#define STRLEN_JVM_SHUT_DOWN_ELEMENT			15
#define TRACE_STOP_ELEMENT						"traceEnd"
#define STRLEN_TRACE_STOP_ELEMENT				8
#define CLASS_UNLOAD_ELEMENT					"classUnload"
#define STRLEN_CLASS_UNLOAD_ELEMENT				11
#define JVM_INIT_DONE_ELEMENT					"runtimeInitDone"
#define STRLEN_JVM_INIT_DONE_ELEMENT			15
#define OBJ_ALLOC_ELEMENT						"objAlloc"
#define STRLEN_OBJ_ALLOC_ELEMENT				8
#define GC_START_ELEMENT						"gcStart"
#define STRLEN_GC_START_ELEMENT					7
#define GC_FINISH_ELEMENT						"gcFinish"
#define STRLEN_GC_FINISH_ELEMENT				8
#define HD_START_ELEMENT						"heapDumpDef"
#define STRLEN_HD_START_ELEMENT					11
#define HD_FINISH_ELEMENT						"hdFinish"
#define STRLEN_HD_FINISH_ELEMENT				8
#define OBJ_FREE_ELEMENT						"objFree"
#define STRLEN_OBJ_FREE_ELEMENT					7
#define OBJ_MOVE_ELEMENT						"objMove"
#define STRLEN_OBJ_MOVE_ELEMENT					7
#define THREAD_END_ELEMENT						"threadEnd"
#define STRLEN_THREAD_END_ELEMENT				9
#define OPTION_ELEMENT							"option"
#define STRLEN_OPTION_ELEMENT					6
#define FILTER_ELEMENT							"filter"
#define STRLEN_FILTER_ELEMENT					6
#define THREAD_START_ELEMENT					"threadStart"
#define STRLEN_THREAD_START_ELEMENT				11
#define CLASS_ELEMENT							"CLASS"
#define STRLEN_CLASS_ELEMENT					5
#define CLASS_LOAD_ELEMENT						"classDef"
#define STRLEN_CLASS_LOAD_ELEMENT				8
#define METHOD_ELEMENT							"methodDef"
#define STRLEN_METHOD_ELEMENT					9
#define STATIC_FIELD_ELEMENT					"staticField"
#define STRLEN_STATIC_FIELD_ELEMENT				11
#define INSTANCE_FIELD_ELEMENT					"instanceField"
#define STRLEN_INSTANCE_FIELD_ELEMENT			13
#define METHOD_COUNT_ELEMENT					"methodCount"
#define STRLEN_METHOD_COUNT_ELEMENT				11
#define TRACE_START_ELEMENT						"traceStart"
#define STRLEN_TRACE_START_ELEMENT				10
#define PROCESS_SUSPEND_ELEMENT					"processSuspend"
#define STRLEN_PROCESS_SUSPEND_ELEMENT			14
#define PROCESS_RESUME_ELEMENT					"processResume"
#define STRLEN_PROCESS_RESUME_ELEMENT			13
#define TRACE_ELEMENT							"traceRoot"
#define STRLEN_TRACE_ELEMENT					9
#define CATCH_ELEMENT							"catch"
#define STRLEN_CATCH_ELEMENT					5
#define THROW_ELEMENT							"throw"
#define STRLEN_THROW_ELEMENT					5
#define METHOD_ENTRY_ATTRIBUTE					"methodEntry"
#define STRLEN_METHOD_ENTRY_ATTRIBUTE			11
#define METHOD_CALL_ATTRIBUTE					"methodCall"
#define STRLEN_METHOD_CALL_ATTRIBUTE			10
#define AGENT_CREATE_ELEMENT                    "agentCreate"
#define STRLEN_AGENT_CREATE_ELEMENT             11
#define AGENT_DESTROY_ELEMENT                   "agentDestroy"
#define STRLEN_AGENT_DESTROY_ELEMENT            12
#define NODE_ELEMENT                            "node"
#define STRLEN_NODE_ELEMENT                     4
#define PROCESS_CREATE_ELEMENT                  "processCreate"
#define STRLEN_PROCESS_CREATE_ELEMENT           13
#define LINE_ELEMENT							"line"
#define STRLEN_LINE_ELEMENT						4
#define OBJECT_REFERENCE_ATTRIBUTE				"objReference"
#define STRLEN_OBJECT_REFERENCE_ATTRIBUTE		12
#define STATIC_REFERENCE_ATTRIBUTE				"staticReference"
#define STRLEN_STATIC_REFERENCE_ATTRIBUTE       15
#define GC_ROOT_ELEMENT							"gcRoot"
#define STRLEN_GC_ROOT_ELEMENT					6

#define MONITOR_WAIT_ELEMENT					"monWait"
#define STRLEN_MONITOR_WAIT_ELEMENT				7
#define MONITOR_WAITED_ELEMENT					"monWaited"
#define STRLEN_MONITOR_WAITED_ELEMENT			9
#define MONITOR_STILL_OWNED_EVENT				"monStillOwned"
#define STRLEN_MONITOR_STILL_OWNED_EVENT		13
#define MONITOR_CONTENDED_ENTER_ELEMENT			"monContendedEnter"
#define STRLEN_MONITOR_CONTENDED_ENTER_ELEMENT	17
#define MONITOR_CONTENDED_ENTERED_ELEMENT		"monContendedEntered"
#define STRLEN_MONITOR_CONTENDED_ENTERED_ELEMENT 19

/* The following 2 constants were added for bug 135437 (preAgg piAgent). */
#define AG_METHOD_ENTRY_ELEMENT					"agMethodEntry"
#define STRLEN_AG_METHOD_ENTRY_ELEMENT			13
#define AG_METHOD_EXIT_ELEMENT					"agMethodExit"
#define STRLEN_AG_METHOD_EXIT_ELEMENT			12



/* XML Attributes */

#define CLASS_ID_ATTRIBUTE						"transientClassId"
#define STRLEN_CLASS_ID_ATTRIBUTE				16
#define CLASS_IDREF_ATTRIBUTE					"transientClassIdRef"
#define STRLEN_CLASS_IDREF_ATTRIBUTE			19
#define METHOD_ID_ATTRIBUTE						"transientMethodId"
#define STRLEN_METHOD_ID_ATTRIBUTE				17
#define METHOD_IDREF_ATTRIBUTE					"transientMethodIdRef"
#define STRLEN_METHOD_IDREF_ATTRIBUTE			20
#define OBJ_ID_ATTRIBUTE						"transientObjId"
#define STRLEN_OBJ_ID_ATTRIBUTE					14
#define OBJ_IDREF_ATTRIBUTE						"transientObjIdRef"
#define STRLEN_OBJ_IDREF_ATTRIBUTE				17
#define THREAD_ID_ATTRIBUTE						"transientThreadId"
#define STRLEN_THREAD_ID_ATTRIBUTE				17
#define STATIC_THREAD_ID_ATTRIBUTE				"threadId"
#define STRLEN_STATIC_THREAD_ID_ATTRIBUTE		8
#define THREAD_IDREF_ATTRIBUTE					"transientThreadIdRef"
#define STRLEN_THREAD_IDREF_ATTRIBUTE			20
#define STATIC_THREAD_IDREF_ATTRIBUTE			"threadIdRef"
#define STRLEN_STATIC_THREAD_IDREF_ATTRIBUTE	11
#define STATIC_CLASS_ID_ATTRIBUTE				"classId"
#define STRLEN_STATIC_CLASS_ID_ATTRIBUTE		7
#define STATIC_CLASS_IDREF_ATTRIBUTE			"classIdRef"
#define STRLEN_STATIC_CLASS_IDREF_ATTRIBUTE		10
#define STATIC_OBJ_ID_ATTRIBUTE					"objId"
#define STRLEN_STATIC_OBJ_ID_ATTRIBUTE			5
#define STATIC_OBJ_IDREF_ATTRIBUTE				"objIdRef"
#define STRLEN_STATIC_OBJ_IDREF_ATTRIBUTE		8
#define STATIC_METHOD_ID_ATTRIBUTE				"methodId"
#define STRLEN_STATIC_METHOD_ID_ATTRIBUTE		8
#define STATIC_METHOD_IDREF_ATTRIBUTE			"methodIdRef"
#define STRLEN_STATIC_METHOD_IDREF_ATTRIBUTE	11

/* Test  */
#define TRACE_FLAG4OWN_ATTRIBUTE 				"traceFlag4Own"
#define STRLEN_TRACE_FLAG4OWN_ATTRIBUTE			13
#define TRACE_FLAG4REF_ATTRIBUTE 				"traceFlag4Ref"
#define STRLEN_TRACE_FLAG4REF_ATTRIBUTE			13
/* Test  */

#define STATIC_ID_ATTRIBUTE						"static_id"
#define STRLEN_STATIC_ID_ATTRIBUTE				9
#define OBJ_HANDLE_ATTRIBUTE					"objHandle"
#define STRLEN_OBJ_HANDLE_ATTRIBUTE				9
#define TICKET_ATTRIBUTE						"ticket"
#define STRLEN_TICKET_ATTRIBUTE					6
#define ENV_ID_ATTRIBUTE						"env_id"
#define STRLEN_ENV_ID_ATTRIBUTE					6
#define STACK_DEPTH_ATTRIBUTE					"stackDepth"
#define STRLEN_STACK_DEPTH_ATTRIBUTE			10
#define ID_ATTRIBUTE							"id"
#define STRLEN_ID_ATTRIBUTE						2
#define USED_OBJECTS_ATTRIBUTE					"usedObjects"
#define STRLEN_USED_OBJECTS_ATTRIBUTE			11
#define USED_OBJECT_SPACE_ATTRIBUTE				"usedObjSpace"
#define STRLEN_USED_OBJECT_SPACE_ATTRIBUTE		12
#define TOTAL_OBJECT_SPACE_ATTRIBUTE			"totalObjSpace"
#define STRLEN_TOTAL_OBJECT_SPACE_ATTRIBUTE		13
#define ARENA_ID_ATTRIBUTE						"arena_id"
#define STRLEN_ARENA_ID_ATTRIBUTE				8
#define IS_ARRAY_ATTRIBUTE						"isArray"
#define STRLEN_IS_ARRAY_ATTRIBUTE				7
#define SIZE_ATTRIBUTE							"size"
#define STRLEN_SIZE_ATTRIBUTE					4
#define NEW_ARENA_ID_ATTRIBUTE					"new_arena_id"
#define STRLEN_NEW_ARENA_ID_ATTRIBUTE			12
#define NEW_OBJ_ID_ATTRIBUTE					"newObjId"
#define STRLEN_NEW_OBJ_ID_ATTRIBUTE				8
#define THREAD_NAME_ATTRIBUTE					"threadName"
#define STRLEN_THREAD_NAME_ATTRIBUTE			10
#define GROUP_NAME_ATTRIBUTE					"groupName"
#define STRLEN_GROUP_NAME_ATTRIBUTE				9
#define PARENT_NAME_ATTRIBUTE					"parentName"
#define STRLEN_PARENT_NAME_ATTRIBUTE			10
#define THREAD_OBJ_ID_ATTRIBUTE					"thread_obj_id"
#define STRLEN_THREAD_OBJ_ID_ATTRIBUTE			13
#define THREAD_ENV_ID_ATTRIBUTE					"thread_env_id"
#define STRLEN_THREAD_ENV_ID_ATTRIBUTE			13
#define KEY_ATTRIBUTE							"key"
#define STRLEN_KEY_ATTRIBUTE					3
#define VALUE_ATTRIBUTE							"value"
#define STRLEN_VALUE_ATTRIBUTE					5
#define TIME_ATTRIBUTE							"time"
#define STRLEN_TIME_ATTRIBUTE					4
#define THREAD_CPU_TIME_ATTRIBUTE				"cpuTime"
#define STRLEN_THREAD_CPU_TIME_ATTRIBUTE		7
#define TYPE_ATTRIBUTE							"type"
#define STRLEN_TYPE_ATTRIBUTE					4
#define CLASS_MODE_ATTRIBUTE					"mode"
#define STRLEN_CLASS_MODE_ATTRIBUTE				4
#define METHOD_MODE_ATTRIBUTE					"methodMode"
#define STRLEN_METHOD_MODE_ATTRIBUTE			10
#define PATTERN_ATTRIBUTE						"pattern"
#define STRLEN_PATTERN_ATTRIBUTE				7
#define METHOD_PATTERN_ATTRIBUTE				"methodPattern"
#define STRLEN_METHOD_PATTERN_ATTRIBUTE			13
#define GENERICPATTERN_ATTRIBUTE				"genericPattern"
#define STRLEN_GENERICPATTERN_ATTRIBUTE			14
#define METHOD_GENERICPATTERN_ATTRIBUTE			"methodGenericPattern"
#define STRLEN_METHOD_GENERICPATTERN_ATTRIBUTE	20
#define NAME_ATTRIBUTE							"name"
#define STRLEN_NAME_ATTRIBUTE					4
#define SIGNATURE_ATTRIBUTE						"signature"
#define STRLEN_SIGNATURE_ATTRIBUTE				9
#define START_LINENO_ATTRIBUTE					"startLineNumber"
#define STRLEN_START_LINENO_ATTRIBUTE			15
#define END_LINENO_ATTRIBUTE					"endLineNumber"
#define STRLEN_END_LINENO_ATTRIBUTE				13
#define IS_NATIVE_ATTRIBUTE						"isNative"
#define STRLEN_IS_NATIVE_ATTRIBUTE				8
#define IS_ABSTRACT_ATTRIBUTE					"isAbstract"
#define STRLEN_IS_ABSTRACT_ATTRIBUTE			10
#define IS_STATIC_ATTRIBUTE						"isStatic"
#define STRLEN_IS_STATIC_ATTRIBUTE				8
#define IS_SYNCHRONIZED_ATTRIBUTE				"isSynchronized"
#define STRLEN_IS_SYNCHRONIZED_ATTRIBUTE		14
#define VISIBILITY_ATTRIBUTE					"visibility"
#define STRLEN_VISIBILITY_ATTRIBUTE				10
#define EXCEPTIONS_ATTRIBUTE					"exceptions"
#define STRLEN_EXCEPTIONS_ATTRIBUTE				10
#define SOURCE_NAME_ATTRIBUTE					"sourceName"
#define STRLEN_SOURCE_NAME_ATTRIBUTE			10
#define NUM_INTERFACES_ATTRIBUTE				"numInterfaces"
#define STRLEN_NUM_INTERFACES_ATTRIBUTE			13
#define CLASS_LOADER_NAME						"classLoader"
#define STRLEN_CLASS_LOADER_NAME				11
#define SUPER_CLASS_NAME_ATTRIBUTE				"superclass"
#define STRLENT_SUPER_CLASS_NAME_ATTRIBUTE		10
#define INTERFACE_NAMES_ATTRIBUTE				"interfaceNames"
#define STRLEN_INTERFACE_NAMES_ATTRIBUTE		14
#define NUM_METHODS_ATTRIBUTE					"numMethods"
#define STRLEN_NUM_METHODS_ATTRIBUTE			10
#define FIELD_ID_ATTRIBUTE						"fieldId"
#define STRLEN_FIELD_ID_ATTRIBUTE				7
#define FIELD_IDREF_ATTRIBUTE					"fieldIdRef"
#define STRLEN_FIELD_IDREF_ATTRIBUTE			10
#define NUM_STATIC_FIELDS_ATTRIBUTE				"numStaticFields"
#define STRLEN_NUM_STATIC_FIELDS_ATTRIBUTE		15
#define NUM_INSTANCE_FIELDS_ATTRIBUTE			"numInstanceFields"
#define STRLEN_NUM_INSTANCE_FIELDS_ATTRIBUTE	17
#define COUNT_ATTRIBUTE							"count"
#define STRLEN_COUNT_ATTRIBUTE					5
#define PID_ATTRIBUTE							"pid"
#define STRLEN_PID_ATTRIBUTE					3
#define HOSTNAME_ATTRIBUTE						"hostname"
#define STRLEN_HOSTNAME_ATTRIBUTE				8
#define IPADDRESS_ATTRIBUTE						"ipaddress"
#define STRLEN_IPADDRESS_ATTRIBUTE				9
#define DATE_ATTRIBUTE							"date"
#define STRLEN_DATE_ATTRIBUTE					4
#define TIMEZONE_ATTRIBUTE						"timezone"
#define STRLEN_TIMEZONE_ATTRIBUTE				8
#define INVOCATIONOPTIONS_ATTRIBUTE				"invocationOptions"
#define STRLEN_INVOCATIONOPTIONS_ATTRIBUTE		17
#define TRACE_ID_ATTRIBUTE	                    "traceId"
#define STRLEN_TRACE_ID_ATTRIBUTE               7
#define TRACE_IDREF_ATTRIBUTE                   "traceIdRef"
#define STRLEN_TRACE_IDREF_ATTRIBUTE            10
#define AGENT_ID_ATTRIBUTE                      "agentId"
#define STRLEN_AGENT_ID_ATTRIBUTE               7
#define AGENT_IDREF_ATTRIBUTE                   "agentIdRef"
#define STRLEN_AGENT_IDREF_ATTRIBUTE            10
#define PROCESS_IDREF_ATTRIBUTE                 "processIdRef"
#define STRLEN_PROCESS_IDREF_ATTRIBUTE          12
#define AGENT_NAME_ATTRIBUTE                    "agentName"
#define STRLEN_AGENT_NAME_ATTRIBUTE             9
#define AGENT_PARAMETERS_ATTRIBUTE              "agentParameters"
#define STRLEN_AGENT_PARAMETERS_ATTRIBUTE       15
#define COLLATION_VALUE_ATTRIBUTE               "collationValue"
#define STRLEN_COLLATION_VALUE_ATTRIBUTE        14
#define NODE_ID_ATTRIBUTE                       "nodeId"
#define STRLEN_NODE_ID_ATTRIBUTE                6
#define NODE_IDREF_ATTRIBUTE                    "nodeIdRef"
#define STRLEN_NODE_IDREF_ATTRIBUTE             9
#define PROCESS_ID_ATTRIBUTE                    "processId"
#define STRLEN_PROCESS_ID_ATTRIBUTE             9
#define ENVIRONMENT_ATTRIBUTE                   "environment"
#define STRLEN_ENVIRONMENT_ATTRIBUTE            11
#define APPLICATION_PARMS_ATTRIBUTE             "application_parameters"
#define STRLEN_APPLICATION_PARMS_ATTRIBUTE      22
#define APPLICATION_NAME_ATTRIBUTE              "application_executable"
#define STRLEN_APPLICATION_NAME_ATTRIBUTE       22
#define PROCESS_OPTIONS_ATTRIBUTE               "process_options"
#define STRLEN_PROCESS_OPTIONS_ATTRIBUTE        15
#define SEQUENCE_COUNTER_ATTRIBUTE              "sequenceCounter"
#define STRLEN_SEQUENCE_COUNTER_ATTRIBUTE       15
#define CONTEXT_DATA_ATTRIBUTE                  "contextData"
#define STRLEN_CONTEXT_DATA_ATTRIBUTE           11
#define AGENT_VERSION_ATTRIBUTE		            "version"
#define STRLEN_AGENT_VERSION_ATTRIBUTE          7
#define LINE_NUMBER_ATTRIBUTE					"line_number"
#define STRLEN_LINE_NUMBER_ATTRIBUTE			11
#define OBJECT_OWNER_ATTRIBUTE					"ownerObjIdRef"
#define STRLEN_OBJECT_OWNER_ATTRIBUTE			13
#define OBJECT_TARGET_ATTRIBUTE					"targetObjIdRef"
#define STRLEN_OBJECT_TARGET_ATTRIBUTE			14
#define OBJECT_ARRAY_INDEX_ATTRIBUTE	    	"objArrayIndex"
#define STRLEN_OBJECT_ARRAY_INDEX_ATTRIBUTE	    13
#define OBJECT_FIELD_INDEX_ATTRIBUTE	    	"fieldIndex"
#define STRLEN_OBJECT_FIELD_INDEX_ATTRIBUTE	    10
#define HEAPDUMP_IDREF_ATTRIBUTE				"heapDumpIdRef"
#define STRLEN_HEAPDUMP_IDREF_ATTRIBUTE			13
#define HEAPDUMP_ID_ATTRIBUTE					"heapDumpId"
#define STRLEN_HEAPDUMP_ID_ATTRIBUTE			10
#define AGENT_TYPE_ATTRIBUTE					"agentType"
#define STRLEN_AGENT_TYPE_ATTRIBUTE				9
#define BASETIME_ATTRIBUTE						"basetime"
#define STRLEN_BASETIME_ATTRIBUTE				8

/* The following 3 constants were added for bug 135437 (preAgg piAgent).
 * A second version of bastetime (ie: baseTime) was added because that 
 * is the preferred casing of the loader going forward but the old 
 * casing is needed for backward compatability 
 */
#define BASETIME1_ATTRIBUTE						"baseTime"
#define STRLEN_BASETIME1_ATTRIBUTE				8
#define MAXTIME_ATTRIBUTE						"maxTime"
#define STRLEN_MAXTIME_ATTRIBUTE				7
#define MINTIME_ATTRIBUTE						"minTime"
#define STRLEN_MINTIME_ATTRIBUTE				7

#define CLASS_OWNER_ATTRIBUTE					"ownerClassIdRef"
#define STRLEN_CLASS_OWNER_ATTRIBUTE			15
#define OVERHEAD_ATTRIBUTE						"overhead"
#define STRLEN_OVERHEAD_ATTRIBUTE				8
#define GC_ROOT_TYPE_ATTRIBUTE					"type"
#define STRLEN_GC_ROOT_TYPE_ATTRIBUTE			4
#define HEAPDUMP_FIRST_SEEN_ATTRIBUTE			"firstSeenIndex"
#define STRLEN_HEAPDUMP_FIRST_SEEN_ATTRIBUTE	14

#define TIMEOUT_ATTRIBUTE						"timeout"
#define STRLEN_TIMEOUT_ATTRIBUTE				7
#define THREAD_OWNER_ATTRIBUTE					"threadOwner"
#define STRLEN_THREAD_OWNER_ATTRIBUTE			11

/* XML Attribute Values */
#define CLASS_VALUE								"CLASS"
#define METHOD_VALUE							"METHOD"
#define INCLUDE_VALUE							"INCLUDE"
#define EXCLUDE_VALUE							"EXCLUDE"
#define PREFIX_VALUE							"PREFIX"
#define SUFFIX_VALUE							"SUFFIX"
#define NONE_VALUE								"NONE"

#endif
