/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: hcthread.h,v 1.2 2007/04/06 01:29:32 jkubasta Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

#include <jni.h>
#include <stdio.h>
#include <stdarg.h>
#include <string.h>

#include "RABindings.h"
#include "RADataTransfer.h"
#include "RAShm.h"
#include "RASocket.h"

/* Strings */
#if defined(__OS400__)
	#pragma convert(819)
#elif defined(MVS)
	#pragma convlit(suspend)
#endif

#define THREAD_DUMP_AGENT_CLASS_NAME "org/eclipse/hyades/logging/jvm/threadanalysis/ThreadDumpAgentImpl"
#define THREAD_DUMP_AGENT_PROCESSOR "processDumpData"
#define THREAD_DUMP_AGENT_PROCESSOR_ARGS "(Ljava/lang/String;)Ljava/lang/String;"
#define AGENT_NAME "Thread Analysis Agent"
#define AGENT_TYPE "Logging"

#if defined(__OS400__)
	#pragma convert(0)
#elif defined(MVS)
	#pragma convlit(resume)
#endif

/* Macro to simplify the JNI code. */
#if defined __cplusplus && defined _HPUX
	#define ENV(e) e
	#define ENVPARM(e)
#else
	#define ENV(e) (*e)
	#define ENVPARM(e) e,
#endif

/* Macro for findind the current working directory */
#if defined(_WIN32)
	#include <direct.h>
	#include <signal.h>
	#include <process.h>
	#define getcwd _getcwd
	#define getpid _getpid
#else
	#include <unistd.h>
	#include <signal.h>
#endif

/* Macro for debug messages */
#if defined(MVS) || defined(__OS400__)
	#define vsnprintf(a,b,c,d) vsprintf(a,c,d)
#elif defined(_WIN32)
	#define vsnprintf _vsnprintf
#endif

void init(char* name, char* type);
void dump();
void deregister();
void hc_dumpThreads();
void autodump();
void getRunningDir(char* buffer);
void messageHandler(ra_command_t *command);
void processDumpData(char* path);
void debugTrace(char* msg, ...);
void autodump(int interval);
void *autoDumpThread(void *args);

#if defined(_WIN32)
DWORD WINAPI autoDumpProxy(LPVOID args);
void sleep(int sec);
#elif defined(__linux__)
void getProcessStat(int pid, char* value);
BOOL isProcessName(int pid, char* pname);
int getParentProcessId(int pid);
#endif
