
################################################################################
#                                           
#  makefile:  tptpProcessController project 
#                                           
# $Id: TPTPProcessController_aix.make,v 1.1 2009/07/10 00:11:34 jwest Exp $                                  
################################################################################


#-----------------------------------
#
#   Customizable section
#
#-----------------------------------
TARGET         :=  tptpProcessController
TARGETDIR      :=  ../../../bin
 

#-----------------------------------
#   list of additional INCLUDE directories to search headers from
#      (separated by blanks)
#-----------------------------------
INCLUDEDIRS    :=  ../transport/RACommon ../transport/RASharedMemory ../transport/RASocket . ../../../include ../../../lib  ${XERCESC_HOME}/include


#-----------------------------------
#   list of additional libraries to be linked with
#      (separated by blanks)
#-----------------------------------
LIBS       :=  tptpUtils tptpLogUtils processControlUtil tptpAgentBase tptpConfig namedPipeTL transportSupport sharedMemTL xerces-c hcclco hcclsm hccls pthread

#-----------------------------------
#   list of additional library directories to search from
#      (separated by blanks)
#-----------------------------------
LIBDIRS    :=  ../../../lib ${XERCESC_HOME}/lib


#-----------------------------------
#
#
#      -g       produce debug info
#      -Wall    enable all types of warnings
#      -O3      highest level of code optimization
#      -fPIC    generate position-independent code (PIC).
#               This is required for building shared library.
#      -c       compile only
#
#   Linking options
#
#       -Wl       pass options to linker
#       -shared   produce shared library
#       -L        add the given directory to the search path for libraries
#
#-----------------------------------

CFLAGS     :=  $(C_FLAGS) $(DEBUGABLE) $(DEBUGFLAGS) -qflag=i:i $(SIXTYFOURBIT) $(OPTIMIZABLE) -qpic=large $(addprefix -I,$(INCLUDEDIRS)) -D_AIX

CXXFLAGS   :=  $(CFLAGS)

LINKOPTS   :=  $(L_FLAGS) $(DEBUGABLE) $(DEBUGLIBS) -brtl $(SIXTYFOURBIT) -o $(TARGETDIR)/$(TARGET) $(addprefix -L,$(LIBDIRS))


#-----------------------------------
#   general commands and options
#-----------------------------------

CC          :=  xlc++_r
CXX         :=  $(CC)

SOURCE     :=  $(wildcard *.c)  $(wildcard *.cpp)

OBJS       :=  $(patsubst %.c,%.o,$(patsubst %.cpp,%.o,$(SOURCE)))

REMOVEFILE :=  rm -f
CREATELINK :=  ln -sf


#-----------------------------------
#   "make" rules
#-----------------------------------

.PHONY : default everything objs clean veryclean rebuild $(TARGET)


default : $(TARGET)


objs : $(OBJS)


clean :
	$(REMOVEFILE) *.o


veryclean: clean
	$(REMOVEFILE) $(TARGETDIR)/$(TARGET)

rebuild: veryclean everything


$(TARGET) : $(OBJS)
	$(CC) $(LINKOPTS) $(OBJS) $(addprefix -l,$(LIBS))
