
################################################################################
#                                           
#  makefile:  tptpProcessController project 
#                                           
# $Id: TPTPProcessController_zos.make,v 1.2 2009/11/30 20:54:05 jwest Exp $                                  
################################################################################


#-----------------------------------
#
#   Customizable section
#
#-----------------------------------
TARGET         :=  tptpProcessController
TARGETDIR      :=  ../../../bin
 

#-----------------------------------
#   list of additional INCLUDE directories to search headers from
#      (separated by blanks)
#-----------------------------------
INCLUDEDIRS    :=  ../transport/RACommon ../transport/RASharedMemory ../transport/RASocket . ../../../include ${XERCESC_HOME}/include


#-----------------------------------
#   list of additional libraries to be linked with
#      (separated by blanks)
#-----------------------------------
LIBS       :=  $(LIBS) ${XERCESC_HOME}/lib/${XERCESC_XFILE} ../../shared/TPTPUtil/libtptpUtils.*.x ../../shared/TPTPLogUtils/libtptpLogUtils.*.x ../../shared/processControlUtil/libprocessControlUtil.*.x ../agentBase/libtptpAgentBase.*.x ../../shared/tptpConfig/libtptpConfig.*.x ../../transport/namedPipeTL/libnamedPipeTL.*.x ../../transport/transportSupport/libtransportSupport.*.x ../../transport/sharedMemTL/libsharedMemTL.*.x ../../transport/RACommon/libhcclco.*.x ../../transport/RASharedMemory/libhcclsm.*.x ../../transport/RASocket/libhccls.*.x

#-----------------------------------
#   list of additional library directories to search from
#      (separated by blanks)
#-----------------------------------
LIBDIRS    :=  ../../../lib ${XERCESC_HOME}/lib


#-----------------------------------
#
#
#      -g       produce debug info
#      -Wall    enable all types of warnings
#      -O3      highest level of code optimization
#      -fPIC    generate position-independent code (PIC).
#               This is required for building shared library.
#      -c       compile only
#
#   Linking options
#
#       -Wl       pass options to linker
#       -shared   produce shared library
#       -L        add the given directory to the search path for libraries
#
#-----------------------------------

CXXFLAGS   :=  $(C_FLAGS) $(DEBUGABLE) $(DEBUGFLAGS) -qflag=i $(OPTIMIZABLE) $(addprefix -I,$(INCLUDEDIRS)) -D_OS390 -D_UNIX03_THREADS -DMVS=1 -D_XOPEN_SOURCE_EXTENDED=1 -D_POSIX_SOURCE -W c,$(SIXTYFOURBIT)CSECT,NOLOCALE,LANGLVL\(EXTENDED\),LONGNAME,DLL,TARGET\(zOSV1R9\),XPLINK

CFLAGS     :=  $(CXXFLAGS),SSCOMM,RENT

LINKOPTS   :=  $(L_FLAGS) $(DEBUGABLE) $(DEBUGLIBS) -W l,$(SIXTYFOURBIT)XPLINK,AMODE=$(AMODEBIT),RMODE=ANY,CALL,REUS=RENT -o $(TARGETDIR)/$(TARGET) $(addprefix -L,$(LIBDIRS))


#-----------------------------------
#   general commands and options
#-----------------------------------

CC          :=  xlc++
CXX         :=  $(CC)

SOURCE     :=  $(wildcard *.c)  $(wildcard *.cpp)

OBJS       :=  $(patsubst %.c,%.o,$(patsubst %.cpp,%.o,$(SOURCE)))

REMOVEFILE :=  rm -f
CREATELINK :=  ln -sf


#-----------------------------------
#   "make" rules
#-----------------------------------

.PHONY : default everything objs clean veryclean rebuild $(TARGET)


default : $(TARGET)


objs : $(OBJS)


clean :
	$(REMOVEFILE) *.o *.dbg


veryclean: clean
	$(REMOVEFILE) $(TARGETDIR)/$(TARGET)

rebuild: veryclean everything


$(TARGET) : $(OBJS)
	$(CC) $(LINKOPTS) $(OBJS) $(LIBS)
