/*******************************************************************************
 * Copyright (c) 2005, 2006 Intel Corporation, IBM.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu K Naikawadi, Intel - Initial API and Implementation (Based on the Java
 *                                API implementation by IBM)
 *
 * $Id: Collector.cpp,v 1.14 2006/02/10 19:54:16 vnaikawadi Exp $
 *
 *******************************************************************************/ 

#include <stdio.h>
#include <iostream>
#include "tptp/client/ControlMessage.h"
#include "GetAgentCommand.h"
#include "tptp/client/Constants.h"
#include "tptp/TPTPSupportTypes.h"
#include "tptp/NoLog.h"
#include "tptp/client/Collector.h"



using namespace std;
using namespace TPTP::Client;


Collector::Collector()
{
	
}

Collector::Collector(int id, char* name) : Agent(id, name)
{

}

Collector::Collector(char* name) : Agent(name)
{
	
}



Collector::~Collector()
{
	
}



void Collector::run()
{
	char	tempbuf[1024];
	
	//Send the establishDataPath command
	TPTP_LOG_DEBUG_MSG("Sending run() command");
	sprintf(tempbuf, "<run iid=\"org.eclipse.tptp.Collector\"></run>");

	CollectorCommandHandler* collectorCmdHandler = new CollectorCommandHandler();

	this->sendCommand(tempbuf, collectorCmdHandler);

	int rc = tptp_waitSemaphore(collectorCmdHandler->getResponseReceivedSem());
	if (rc != 0)
	{
		TPTP_LOG_ERROR_MSG("Client Collector: Error - wait for run command response failed.");		
		return;
	};

	delete(collectorCmdHandler);
}


void Collector::stop()
{
	char	tempbuf[1024];
	
	//Send the establishDataPath command
	TPTP_LOG_DEBUG_MSG("Sending stop() command");

	sprintf(tempbuf, "<stop iid=\"org.eclipse.tptp.Collector\"></stop>");

	CollectorCommandHandler* collectorCmdHandler = new CollectorCommandHandler();

	this->sendCommand(tempbuf, collectorCmdHandler);

	int rc = tptp_waitSemaphore(collectorCmdHandler->getResponseReceivedSem());
	if (rc != 0)
	{
		TPTP_LOG_ERROR_MSG("Client Collector: Error - wait for stop command response failed.");
		return;
	};

	TPTP_LOG_DEBUG_MSG("The Agent is Stopped.");

	delete(collectorCmdHandler);
}


void Collector::cancel()
{

	char	tempbuf[1024];
	
	//Send the establishDataPath command
	TPTP_LOG_DEBUG_MSG("Sending cancel() command");

	sprintf(tempbuf, "<cancel iid=\"org.eclipse.tptp.Collector\"></cancel>");

	CollectorCommandHandler* collectorCmdHandler = new CollectorCommandHandler();

	this->sendCommand(tempbuf, collectorCmdHandler);

	int rc = tptp_waitSemaphore(collectorCmdHandler->getResponseReceivedSem());
	if (rc != 0)
	{
		TPTP_LOG_ERROR_MSG("Client Collector: Error - wait for cancel command response failed.");
		return;
	};

	delete(collectorCmdHandler);
}

void Collector::pause()
{

	char	tempbuf[1024];
	
	//Send the establishDataPath command
	TPTP_LOG_DEBUG_MSG("Sending pause() command");

	sprintf(tempbuf, "<pause iid=\"org.eclipse.tptp.Collector\"></pause>");

	CollectorCommandHandler* collectorCmdHandler = new CollectorCommandHandler();

	this->sendCommand(tempbuf, collectorCmdHandler);

	int rc = tptp_waitSemaphore(collectorCmdHandler->getResponseReceivedSem());
	if (rc != 0)
	{
		TPTP_LOG_ERROR_MSG("Client Collector: Error - wait for pause command response failed.");
		return;
	};

	delete(collectorCmdHandler);
}


void Collector::resume()
{
	char	tempbuf[1024];
	
	//Send the establishDataPath command
	TPTP_LOG_DEBUG_MSG("Sending resume() command");

	sprintf(tempbuf, "<resume iid=\"org.eclipse.tptp.Collector\"></resume>");

	CollectorCommandHandler* collectorCmdHandler = new CollectorCommandHandler();

	this->sendCommand(tempbuf, collectorCmdHandler);

	int rc = tptp_waitSemaphore(collectorCmdHandler->getResponseReceivedSem());
	if (rc != 0)
	{
		TPTP_LOG_ERROR_MSG("Client Collector: Error - wait for resume command response failed.");
		return;
	};

	delete(collectorCmdHandler);
}



void CollectorCommandHandler::incomingCommand(INode* node, CommandElement* command)
{
	TPTP_LOG_DEBUG_MSG("Collector Command Handler called");

	//AgentCommandHandler::incomingCommand(node, command);

	//if (responseReceived != -1) return;

	TPTP_LOG_DEBUG_MSG1("The response received from the Collector : %s", command->getCommand());

	int            ret = -1;
	int            sourceID;
	int            contextID;
	char*          interfaceName=0;
	char*          cmdName=0;
	tptp_list_t*   paramList=0;

	ret = parseCommand(command->getCommand(), &sourceID, &contextID, &interfaceName, &cmdName, &paramList );

	if(isEqualString(cmdName, "agentRunning"))
	{		
		responseReceived = 100;
	}
	else if(isEqualString(cmdName, "agentStopped"))
	{
		responseReceived = 101;
	}
	else if(isEqualString(cmdName, "agentCancelled"))
	{
		responseReceived = 102;
	}
	else if(isEqualString(cmdName, "agentPaused"))
	{
		responseReceived = 103;
	}
	else if(isEqualString(cmdName, "agentResumed"))
	{
		responseReceived = 104;
	}

	if (responseReceived != -1)
	{
		int rc = tptp_postSemaphore(&responseReceivedSem);
		if (rc != 0)
		{
			TPTP_LOG_ERROR_MSG("AgentCommandHandler: Error - failed to post event for response received.");
		};
	}

	// Free space allocated by parseCommand()
	if (ret != -1)
	{
		if (interfaceName)tptp_free(interfaceName);
		if(cmdName)tptp_free(cmdName);
		if(paramList)
		{
			tptp_list_clear(paramList);
			tptp_free(paramList);
		}
	}
	
}







