/*******************************************************************************
 * Copyright (c) 2005 IBM, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Guru Nagarajan, Intel - initial API and implementation
 *    IBM - Initial Java API and implementation
 *
 * $Id: CommandElement.cpp,v 1.7 2005/10/16 18:28:28 gnagarajan Exp $
 *
 *******************************************************************************/ 

#include "tptp/client/CommandElement.h"
#include "tptp/TPTPUtils.h"
#include <stdio.h>
#ifndef _WIN32
#include <string.h>
#endif

unsigned long CommandElement::getContext()
{ 
	return _context; 
}

unsigned long CommandElement::getTag()
{ 
	return _tag;
}

unsigned long CommandElement::getDestination()
{ 
	return _dest;
}

unsigned long CommandElement::getSource()
{ 
	return _src;
}

char* CommandElement::getCommand()
{ 
	return _command;
}

void CommandElement::setSource(unsigned long source)
{ 
	_src = source;
}

void CommandElement::setContext(unsigned long context)
{ 
	_context = context;
}

void CommandElement::setDestination(unsigned long dest)
{ 
	_dest = dest;
}


void CommandElement::setCommand(char* command)
{ 
	if (command)
	{
		int len = strlen(command) + 1;
		_command = (char *) tptp_malloc(len);
		memcpy(_command, command, len);
	}
	else
		_command = NULL;
}


CommandElement::CommandElement()
{
	_tag = 0;
	_context = 0;
	_dest = 0;
	_src = 0;
	_command = NULL;

}

CommandElement::~CommandElement()
{
	if (_command) tptp_free(_command);
	//TO DO: if the setCommandName is used in other classes inheriting from CommElem -GN 10/5/05
	//if (_commandName) tptp_free(_commandName);

}
char* CommandElement::getCommandName()
{
	return this->_commandName;
}

void CommandElement::setCommandName(char *commandName)
{
	if(commandName)
	{
		int len = strlen(commandName)+1;
		_commandName = (char *)tptp_malloc(len);
		memcpy(_commandName, commandName, len);
	}
	else { _commandName = NULL;}
}