/*******************************************************************************
 * Copyright (c) 2005, 2009 IBM, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Guru Nagarajan, Intel - initial API and implementation
 *    IBM - Initial Java API and implementation
 *
 * $Id: CommandFragment.cpp,v 1.21 2009/11/21 22:27:16 jwest Exp $
 *
 *******************************************************************************/

#include <stdio.h>
#include "tptp/client/TPTP_XMLHandler.h"
#include "tptp/client/Constants.h"
#include "tptp/client/CommandFragment.h"
#include "tptp/client/Message.h"
#include "tptp/NoLog.h"

using namespace std;

CommandFragment::CommandFragment()
{
	this->_tag = Constants::NEW_AC_MESSAGE;

}

CommandFragment::~CommandFragment()
{
}

void CommandFragment::setCommand(string command)
{
#if defined(_SOLARIS) || defined(_AIX) || defined(MVS) || defined(_SOLARISX86)
	this->_commandData = TPTP_String(command);	
#else
	this->_commandData = TPTP_String::TPTP_String(command);	
#endif
}


void CommandFragment::setCommandPart(char* commandPart)
{
	this->_commandPart = commandPart;	
}

string CommandFragment::getCommandData()
{
	return this->_commandData.getData();
}



void CommandFragment::buildCommand()
{
	string CommandBuffer = string();
	char	tempbuf[1024];
	
	if (_commandPart != NULL)
	{
		sprintf(tempbuf, "<Cmd dest=\"%ld\" src=\"%ld\" ctxt=\"%ld\">",
				this->getDestination(), this->getSource(), this->getContext());
		CommandBuffer = CommandBuffer + tempbuf;
		//*tempbuf = NULL;
		
		sprintf(tempbuf, this->_commandPart);
		CommandBuffer = CommandBuffer + tempbuf;
		//*tempbuf = NULL;
		
		CommandBuffer = CommandBuffer + CMD_CLOSE_TAG;
#if defined(_SOLARIS) || defined(_AIX) || defined(MVS) || defined(_SOLARISX86)
		this->_commandData = TPTP_String(CommandBuffer);
#else
		this->_commandData = TPTP_String::TPTP_String(CommandBuffer);
#endif
	}
	
}

unsigned int CommandFragment::getSize()
{
	unsigned int size = 0;
	size = this->_commandData.getData().length();
	return size;
}

unsigned char* CommandFragment::writeToBuffer(unsigned char *buffer,unsigned int offset)
{
	unsigned char* current;
	current = buffer;

	current= Message::copyTPTPSTRINGToBuffer(current,this->_commandData.getData());

	return current;
}

vector<string> CommandFragment::getXMLFromBuf(string input)
{
	vector<string> temp;
	int startIndex = 0;
    int retIndex = startIndex;
    while (retIndex > 0 || ((int)string::npos != retIndex))
    {
		retIndex = input.find(CMD_CLOSE_TAG, startIndex);
	  if((int)string::npos == retIndex){break;}
	  temp.push_back(input.substr(startIndex,retIndex-startIndex+strlen(CMD_CLOSE_TAG)));
      startIndex = retIndex+strlen(CMD_CLOSE_TAG);
	} 
	return temp;
}

unsigned char* CommandFragment::readFromBuffer(unsigned char *buffer,unsigned int offset)
{
	
#if !defined(__x86_64__) && !(defined(__linux__) && defined(__s390__)) && !(defined(_SOLARIS)) && !(defined(_AIX)) && !defined(MVS) && !(defined(_SOLARISX86))
	string data;
	string tempdata;
	string Temp = (char *)buffer;
	vector<string> temp;

	//data=new String(buffer, offset, Temp.indexOf("</Cmd>",offset), "UTF-8");
	//else data=new String(buffer, 0, offset, Temp.indexOf("</Cmd>",offset));
	
	this->_commandData = data;

	TPTP_LOG_DEBUG_MSG1("The Received Command is: %s", data.c_str());
	temp = CommandFragment::getXMLFromBuf(Temp);
	for(unsigned int i = 0; i < temp.size();i++)
	{
		string agentID;
		//This is dead code
		agentID= TPTP_XMLHandler::getAgentID(temp[i].c_str());
	}
	
#endif	
	return buffer;
}

