/*******************************************************************************
 * Copyright (c) 2005, 2006 Intel Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu K Naikawadi, Intel - Initial API and Implementation
 *
 * $Id: ConnectionInfo.cpp,v 1.4 2006/02/10 19:54:16 vnaikawadi Exp $
 *
 *******************************************************************************/ 


#include "tptp/client/ConnectionInfo.h"


using namespace TPTP::Client;

/**
* Create an environment variable with the specified name
* value pair.
*/
ConnectionInfo::ConnectionInfo(char* hostName, int portNum) 
{
	_hostName = hostName;
	_portNum = portNum;
}

/**
* Retrieve the Host Name
*/
char* ConnectionInfo::getHostName() 
{
	return _hostName;
}


/**
* Set the Host Name
*/
void ConnectionInfo::setHostName(char* hostName) 
{
	_hostName = hostName;
}

/**
* Retrieve the port number
*/
int ConnectionInfo::getPortNum() 
{
	return _portNum;
}

/**
* Set the port number
*/
void ConnectionInfo::setPortNum(int portNum) 
{
	_portNum = portNum;
}

/**
* Retrieve the communication protocol
*/
enum CommProtocol ConnectionInfo::getProtocol() 
{
	return _protocol;
}

/**
* Set the port number
*/
void ConnectionInfo::setProtocol(enum CommProtocol protocol) 
{
	_protocol = protocol;
}


