/*******************************************************************************
 * Copyright (c) 2005, 2006 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu K Naikawadi, Intel - Initial API and Implementation
 *
 * $Id: ConsoleDataProcessor.h,v 1.6 2006/02/10 19:54:16 vnaikawadi Exp $
 *
 *******************************************************************************/ 


#ifndef  ConsoleDataProcessor_H
#define  ConsoleDataProcessor_H


#include "tptp/client/IDataProcessor.h"
#include "tptp/TPTPUtils.h"
#include "tptp/TPTPCommon.h"
#include "ContextMapper.h"

#include <stdio.h>
#include <map>


using namespace TPTP::Client;



class ConsoleDataProcessor: public IDataProcessor
{
	private:
		std::map<long, IDataProcessor*> _contextMapper;

		IDataProcessor* findDataProcessor(long pid);

		Semaphore_t         hasProcessIdSemaphore ;

	public:
		ConsoleDataProcessor();

		~ConsoleDataProcessor();
		/**
		 * Handle the data coming 
		 */
		virtual void incomingData(char buffer[], int length, DIME_HEADER_PTR_T dimeHeader);
		/**
		 * Invalid Data Type
		 */
		virtual void invalidDataType(char data[], int length);
		/**
		 * Waiting for data
		 */
		virtual void waitingForData();


		void addDataProcessor(long pid, IDataProcessor* dataProcessor);

};



#endif

