/*******************************************************************************
 * Copyright (c) 2005,2006 Intel Corporation, IBM.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu K Naikawadi, Intel - Initial API and Implementation (Based on the Java
 *                                API implementation by IBM)
 *
 * $Id: ConsoleImpl.cpp,v 1.5 2006/04/04 22:14:57 kcallaghan Exp $
 *
 *******************************************************************************/ 


#include "ConsoleImpl.h"
#include "tptp/dime.h"
#include "tptp/TPTPMessageHeader.h"

using namespace TPTP::Client;

/**
 * Console constructor comment.
 */
ConsoleImpl::ConsoleImpl()
{
	_processor = 0;
	_started = false;
	_valid  = true;
	_ac=0;
	_dataConnectionID = -1;
}


/**
 * Console constructor comment.
 * @param name java.lang.String
 */
ConsoleImpl::ConsoleImpl(char* name)
{
	_processor = 0;
	_started = false;
	_valid  = true;
	_ac=0;
	_dataConnectionID = -1;
}

/**
 * Console constructor comment.
 */
ConsoleImpl::~ConsoleImpl()
{

}


void ConsoleImpl::setAC(AgentController* ac)
{
	_ac = ac;
}

void ConsoleImpl::setDataConnectionID(int dataConnID)
{
	_dataConnectionID = dataConnID;
}

void ConsoleImpl::setProcessID(long processID)
{
	_processID = processID;
}

/**
 * Insert the method's description here.
 * Creation date: (2/19/01 2:56:30 PM)
 * @param processor org.eclipse.hyades.internal.execution.local.common.DataProcessor
 */
void ConsoleImpl::setDataProcessor(IDataProcessor* processor)
{
	this->_processor = processor;
}


IDataProcessor* ConsoleImpl::getDataProcessor()
{
	return _processor;
}



/**
 * Insert the method's description here.
 * Creation date: (5/28/01 8:01:54 PM)
 * @param data java.lang.String
 */
void ConsoleImpl::write(char* data)
{
	if (data != 0)
	{
		DIME_HEADER_PTR_T dp;
		int dataLength = strlen(data);
		int dimeLength = MAKE_DIME_CONSOLE(&dp, _processID, TPTP_STDIN, dataLength + 1);
		MAKE_NBO_DIME_HEADER((char*)dp);

		char *new_buffer = (char *)tptp_malloc(dimeLength + dataLength + 1);

		memcpy(new_buffer, dp, dimeLength);
		memcpy(new_buffer+dimeLength, data, dataLength + 1);

		//this->_ac->sendConsoleData(data, strlen(data)+1);
		this->_ac->sendData(this->_dataConnectionID, new_buffer, dimeLength + dataLength + 1);
		tptp_free(new_buffer); new_buffer = NULL;
		tptp_free(dp); dp = NULL;
	}
}

/* Closes this console */
void ConsoleImpl::close()
{
	_valid=false;
}

		


