/*******************************************************************************
 * Copyright (c) 2005, 2006 Intel Corporation, IBM.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu K Naikawadi, Intel - Initial API and Implementation (Based on the Java
 *                                API implementation by IBM)
 *
 * $Id: ConsoleImpl.h,v 1.6 2006/02/10 19:54:16 vnaikawadi Exp $
 *
 *******************************************************************************/ 



#ifndef  ConsoleImpl_H
#define  ConsoleImpl_H

#include "tptp/TPTPExport.h"

//#include "TPTPCommon.h"
#include "tptp/client/IConsole.h"
#include "tptp/client/AgentController.h"

#include <stdio.h>
#include <iostream>



namespace TPTP
{
	namespace Client
	{

		class TPTP_CLASS_EXPORT ConsoleImpl: public IConsole
		{
			private:
				IDataProcessor* _processor;
				bool _started;
				bool _valid;
				AgentController* _ac;
				int _dataConnectionID;
				long _processID;
	
				
			public:
				/**
				 * Console constructor comment.
				 */
				ConsoleImpl();

				/**
				 * Console constructor comment.
				 * @param name java.lang.String
				 */
				ConsoleImpl(char* name);



				virtual ~ConsoleImpl();

				void setAC(AgentController* ac);

				void setDataConnectionID(int dataConnID);

				void setProcessID(long processID);


				/**
				 * Insert the method's description here.
				 * Creation date: (2/19/01 2:56:30 PM)
				 * @param processor org.eclipse.hyades.internal.execution.local.common.DataProcessor
				 */
				virtual void setDataProcessor(IDataProcessor* processor);


				virtual IDataProcessor* getDataProcessor();


				/**
				 * Insert the method's description here.
				 * Creation date: (5/28/01 8:01:54 PM)
				 * @param data java.lang.String
				 */
				virtual void write(char* data) ;


				/* Closes this console */
				virtual void close() ;

		};
	}
}


#endif




